/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.data.filter.TimeseriesRowNorm;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowscore.AbstractRowScore;
import adams.data.statistics.StatUtils;
import adams.data.utils.SAXUtils;
import gnu.trove.list.array.TDoubleArrayList;

public class SAXDistanceFromBaseline
extends AbstractRowScore {
    private static final long serialVersionUID = -13137285273610739L;
    protected int m_NumWindows;
    protected int m_NumBins;

    public String globalInfo() {
        return "Applies " + TimeseriesRowNorm.class.getName() + " to the timeseries before calculating the SAX distance of the timeseries to the baseline.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-windows", "numWindows", (Object)10, (Number)1, null);
        this.m_OptionManager.add("num-bins", "numBins", (Object)10, (Number)1, null);
    }

    public void setNumWindows(int value) {
        if (value >= 1) {
            this.m_NumWindows = value;
            this.reset();
        } else {
            this.getLogger().severe("The number of windows must be at least 1, provided: " + value);
        }
    }

    public int getNumWindows() {
        return this.m_NumWindows;
    }

    public String numWindowsTipText() {
        return "The number of windows to use for Piecewise Aggregate Approximation (PAA).";
    }

    public void setNumBins(int value) {
        if (value >= 1) {
            this.m_NumBins = value;
            this.reset();
        } else {
            this.getLogger().severe("The number of bins must be at least 1, provided: " + value);
        }
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use for the Gaussian.";
    }

    public int getNumScores() {
        return 1;
    }

    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = new Double[]{0.0};
        DataRow row = sheet.getRow(rowIndex);
        TDoubleArrayList x = new TDoubleArrayList();
        for (Cell cell : row.cells()) {
            if (!cell.isNumeric()) continue;
            x.add(cell.toDouble().doubleValue());
        }
        double[] norm = StatUtils.rowNorm((double[])x.toArray());
        double[] bps = SAXUtils.calcBreakPoints((int)this.m_NumBins);
        double[][] matrix = SAXUtils.calcDistMatrix((double[])bps);
        double[] normSAX = SAXUtils.toSAX((double[])norm, (int)this.m_NumWindows, (double[])bps);
        double[] baseSAX = new double[normSAX.length];
        result[0] = SAXUtils.minDist((double[])normSAX, (double[])baseSAX, (double[][])matrix, (int)x.size());
        return result;
    }
}

