/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.core.DateFormat;
import adams.data.DateFormatString;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import adams.data.timeseries.AbstractTimeseriesFeatureGenerator;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.ArrayList;
import java.util.List;

public class Values
extends AbstractTimeseriesFeatureGenerator<Timeseries> {
    private static final long serialVersionUID = 9084280445189495060L;
    protected String m_PrefixValue;
    protected String m_PrefixTimestamp;
    protected boolean m_AddTimestamp;
    protected DateFormatString m_TimestampFormat;

    public String globalInfo() {
        return "Simple feature generator that just outputs all the values of a timeseries.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix-value", "prefixValue", (Object)"Value-");
        this.m_OptionManager.add("add-timestamp", "addTimestamp", (Object)false);
        this.m_OptionManager.add("prefix-timestamp", "prefixTimestamp", (Object)"Timestamp-");
        this.m_OptionManager.add("timestamp-format", "timestampFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
    }

    public void setPrefixValue(String value) {
        this.m_PrefixValue = value;
        this.reset();
    }

    public String getPrefixValue() {
        return this.m_PrefixValue;
    }

    public String prefixValueTipText() {
        return "The prefix to use for the values.";
    }

    public void setAddTimestamp(boolean value) {
        this.m_AddTimestamp = value;
        this.reset();
    }

    public boolean getAddTimestamp() {
        return this.m_AddTimestamp;
    }

    public String addTimestampTipText() {
        return "If enabled, the timestamp gets added as well, preceding the value.";
    }

    public void setPrefixTimestamp(String timestamp) {
        this.m_PrefixTimestamp = timestamp;
        this.reset();
    }

    public String getPrefixTimestamp() {
        return this.m_PrefixTimestamp;
    }

    public String prefixTimestampTipText() {
        return "The prefix to use for the timestamps.";
    }

    public void setTimestampFormat(DateFormatString value) {
        this.m_TimestampFormat = value;
        this.reset();
    }

    public DateFormatString getTimestampFormat() {
        return this.m_TimestampFormat;
    }

    public String timestampFormatTipText() {
        return "The format to use for the timestamp strings.";
    }

    @Override
    public HeaderDefinition createHeader(Timeseries timeseries) {
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < timeseries.size(); ++i) {
            if (this.m_AddTimestamp) {
                result.add(this.m_PrefixTimestamp + (i + 1), DataType.STRING);
            }
            result.add(this.m_PrefixValue + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(Timeseries timeseries) {
        ArrayList[] result = new ArrayList[]{new ArrayList()};
        DateFormat tsformat = this.m_TimestampFormat.toDateFormat();
        for (int i = 0; i < timeseries.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)timeseries.toList().get(i));
            if (this.m_AddTimestamp) {
                result[0].add(tsformat.format(point.getTimestamp()));
            }
            result[0].add(point.getValue());
        }
        return result;
    }
}

