/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectexport;

import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.data.container.DataContainer;
import adams.data.io.output.SimpleTimeseriesWriter;
import adams.data.timeseries.Timeseries;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import java.io.File;
import nz.ac.waikato.cms.locator.ClassLocator;

public class TimeseriesExporter
extends AbstractObjectExporter {
    private static final long serialVersionUID = 4899389310274830738L;

    public String getFormatDescription() {
        return "Timeseries files";
    }

    public String[] getFormatExtensions() {
        return new SimpleTimeseriesWriter().getFormatExtensions();
    }

    public boolean handles(Class cls) {
        return ClassLocator.isSubclass(Timeseries.class, (Class)cls);
    }

    protected String doExport(Object obj, File file) {
        try {
            Timeseries data = (Timeseries)((Object)obj);
            SimpleTimeseriesWriter writer = new SimpleTimeseriesWriter();
            writer.setOutput(new PlaceholderFile(file));
            if (!writer.write((DataContainer)data)) {
                return "Failed to write timeseries to '" + file + "'!";
            }
            return null;
        }
        catch (Exception e) {
            return "Failed to write timeseries to '" + file + "'!\n" + LoggingHelper.throwableToString((Throwable)e);
        }
    }
}

