/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.WekaInstancesToTimeseries;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.weka.WekaAttributeIndex;
import adams.env.Environment;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaInstancesToTimeseriesTest
extends AbstractConversionTestCase {
    public WekaInstancesToTimeseriesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("wine.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("wine.arff");
        super.tearDown();
    }

    protected String toString(Object data) {
        Timeseries series = (Timeseries)data;
        StringBuilder result = new StringBuilder();
        for (Object obj : series.toList()) {
            TimeseriesPoint point = (TimeseriesPoint)obj;
            result.append(point.toString());
            result.append("\n");
        }
        return result.toString();
    }

    protected Object[] getRegressionInput() {
        Object[] result = new Instances[1];
        try {
            result[0] = ConverterUtils.DataSource.read((String)new TmpFile("wine.arff").getAbsolutePath());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        WekaInstancesToTimeseries[] result = new WekaInstancesToTimeseries[2];
        result[0] = new WekaInstancesToTimeseries();
        result[0].setDateAttribute(new WekaAttributeIndex("last"));
        result[0].setValueAttribute(new WekaAttributeIndex("first"));
        result[1] = new WekaInstancesToTimeseries();
        result[1].setDateAttribute(new WekaAttributeIndex("last"));
        result[1].setValueAttribute(new WekaAttributeIndex("Dry-white"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(WekaInstancesToTimeseriesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaInstancesToTimeseriesTest.runTest((Test)WekaInstancesToTimeseriesTest.suite());
    }
}

