/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.timeseriessplit;

import adams.core.CleanUpHandler;
import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.io.input.AbstractTimeseriesReader;
import adams.data.report.Report;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.transformer.timeseriessplit.AbstractTimeseriesSplitter;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;

public abstract class AbstractTimeseriesSplitterTestCase
extends AdamsTestCase {
    public AbstractTimeseriesSplitterTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/flow/transformer/timeseriessplit/data");
    }

    protected Timeseries load(String filename, AbstractTimeseriesReader reader) {
        this.m_TestHelper.copyResourceToTmp(filename);
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        Timeseries result = (Timeseries)reader.read().get(0);
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractTimeseriesReader[] getRegressionInputReaders();

    protected abstract AbstractTimeseriesSplitter[] getRegressionSetups();

    protected Timeseries[] process(Timeseries data, AbstractTimeseriesSplitter scheme) {
        return scheme.split(data);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    protected boolean save(Timeseries[] data, String filename) {
        StringBuilder content = new StringBuilder();
        DateFormat dformat = DateUtils.getTimestampFormatterMsecs();
        for (int i = 0; i < data.length; ++i) {
            content.append(i + 1 + "/" + data.length + "\n");
            if (data[i].hasReport()) {
                Report report = data[i].getReport().getClone();
                report.setStringValue("ID", data[i].getID());
                Object[] lines = report.toProperties().toComment().split("\n");
                lines[0] = "";
                Arrays.sort(lines);
                content.append(Utils.flatten((Object[])lines, (String)"\n").trim());
                content.append("\n");
            }
            content.append("Timestamp,Value");
            content.append("\n");
            Iterator iter = data[i].iterator();
            int index = 0;
            while (iter.hasNext()) {
                TimeseriesPoint point = (TimeseriesPoint)iter.next();
                content.append("" + ++index);
                content.append(",");
                content.append(Utils.doubleQuote((String)dformat.format(point.getTimestamp())));
                content.append(",");
                content.append(Utils.doubleToString((double)point.getValue(), (int)6));
                content.append("\n");
            }
            content.append("\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)content.toString(), (boolean)false);
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        AbstractTimeseriesReader[] readers = this.getRegressionInputReaders();
        String[] output = new String[input.length];
        AbstractTimeseriesSplitter[] setups = this.getRegressionSetups();
        AbstractTimeseriesSplitterTestCase.assertEquals((String)"Number of files and readers differ!", (int)input.length, (int)readers.length);
        AbstractTimeseriesSplitterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            Timeseries data = this.load(input[i], readers[i]);
            AbstractTimeseriesSplitterTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            AbstractTimeseriesSplitter current = (AbstractTimeseriesSplitter)OptionUtils.shallowCopy((Object)setups[i]);
            AbstractTimeseriesSplitterTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            Timeseries[] processed = this.process(data, current);
            AbstractTimeseriesSplitterTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractTimeseriesSplitterTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractTimeseriesSplitterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

