/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import adams.data.timeseries.AbstractMetaTimeseriesFeatureGenerator;
import adams.data.timeseries.AbstractTimeseriesFeatureGenerator;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.Values;
import java.util.ArrayList;
import java.util.List;

public class FixedNumFeatures
extends AbstractMetaTimeseriesFeatureGenerator {
    private static final long serialVersionUID = -5349388859224578387L;
    protected int m_NumFeatures;
    protected String m_HeaderTemplate;
    protected FillerType m_FillerType;
    protected double m_FillerNumeric;
    protected String m_FillerString;
    protected boolean m_FillerBoolean;

    public String globalInfo() {
        return "Meta-feature-generator that ensures that the generated output has a fixed number of data points.\nIn case of filler type " + (Object)((Object)FillerType.FIRST_VALUE) + ", the data gets inserted at the start, as opposed to at the end when using " + (Object)((Object)FillerType.LAST_VALUE) + ".\n" + (Object)((Object)FillerType.FILLER_NUMERIC) + "/" + (Object)((Object)FillerType.FILLER_STRING) + "/" + (Object)((Object)FillerType.FILLER_BOOLEAN) + " use the appropriate filler value that the user specified.\nThe MISSING_* types just add a missing value of the appropriate data type.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-features", "numFeatures", (Object)1, (Number)1, null);
        this.m_OptionManager.add("header-template", "headerTemplate", (Object)"Filler-#");
        this.m_OptionManager.add("filler-type", "fillerType", (Object)FillerType.MISSING_NUMERIC);
        this.m_OptionManager.add("filler-numeric", "fillerNumeric", (Object)0.0);
        this.m_OptionManager.add("filler-string", "fillerString", (Object)"");
        this.m_OptionManager.add("filler-boolean", "fillerBoolean", (Object)false);
    }

    @Override
    protected AbstractTimeseriesFeatureGenerator getDefaultGenerator() {
        return new Values();
    }

    public void setNumFeatures(int value) {
        if (value >= 1) {
            this.m_NumFeatures = value;
            this.reset();
        } else {
            this.getLogger().warning("At least 1 feature must be present, provided: " + value);
        }
    }

    public int getNumFeatures() {
        return this.m_NumFeatures;
    }

    public String numFeaturesTipText() {
        return "The number of features to ensure, either trim or fill to satisfy.";
    }

    public void setHeaderTemplate(String value) {
        this.m_HeaderTemplate = value;
        this.reset();
    }

    public String getHeaderTemplate() {
        return this.m_HeaderTemplate;
    }

    public String headerTemplateTipText() {
        return "The template for filling in the header; '#' is 1-based index for filled in value, '$' is 1-based, absolute column index; Using a header definition of 'Att-1,Att-2,Att-3' with a size of 5 will give you: 'Filler-#' -> 'Att-1,Att-2,Att-3,Filler-1,Fillter-2', 'Filler-$' -> 'Att-1,Att-2,Att-3,Filler-4,Filler-5'";
    }

    public void setFillerType(FillerType value) {
        this.m_FillerType = value;
        this.reset();
    }

    public FillerType getFillerType() {
        return this.m_FillerType;
    }

    public String fillerTypeTipText() {
        return "The type of filler to use.";
    }

    public void setFillerNumeric(double value) {
        this.m_FillerNumeric = value;
        this.reset();
    }

    public double getFillerNumeric() {
        return this.m_FillerNumeric;
    }

    public String fillerNumericTipText() {
        return "The value for a numeric filler.";
    }

    public void setFillerString(String value) {
        this.m_FillerString = value;
        this.reset();
    }

    public String getFillerString() {
        return this.m_FillerString;
    }

    public String fillerStringTipText() {
        return "The value for a string filler.";
    }

    public void setFillerBoolean(boolean value) {
        this.m_FillerBoolean = value;
        this.reset();
    }

    public boolean getFillerBoolean() {
        return this.m_FillerBoolean;
    }

    public String fillerBooleanTipText() {
        return "The value for a boolean filler.";
    }

    @Override
    public String converterTipText() {
        return "The base feature converter to use and trim to size or extend.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"numFeatures", (Object)this.m_NumFeatures, (String)"# features: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"fillerType", (Object)((Object)this.m_FillerType), (String)", filler: ");
        result = result + ", " + super.getQuickInfo();
        return result;
    }

    @Override
    public Class getDatasetFormat() {
        return this.m_Converter.getDatasetFormat();
    }

    @Override
    public Class getRowFormat() {
        return this.m_Converter.getRowFormat();
    }

    @Override
    public HeaderDefinition createHeader(Timeseries timeseries) {
        HeaderDefinition fixed = this.m_Generator.createHeader(timeseries).getClone();
        while (fixed.size() > this.m_NumFeatures) {
            if (this.m_FillerType == FillerType.FIRST_VALUE) {
                fixed.remove(0);
                continue;
            }
            fixed.remove(fixed.size() - 1);
        }
        int count = 0;
        block8: while (fixed.size() < this.m_NumFeatures) {
            String name = this.m_HeaderTemplate.replace("#", "" + ++count).replace("$", "" + (fixed.size() + 1));
            switch (this.m_FillerType) {
                case MISSING_BOOLEAN: 
                case FILLER_BOOLEAN: {
                    fixed.add(name, DataType.BOOLEAN);
                    continue block8;
                }
                case MISSING_STRING: 
                case FILLER_STRING: {
                    fixed.add(name, DataType.STRING);
                    continue block8;
                }
                case MISSING_NUMERIC: 
                case FILLER_NUMERIC: {
                    fixed.add(name, DataType.NUMERIC);
                    continue block8;
                }
                case FIRST_VALUE: {
                    fixed.add(0, name, (DataType)fixed.getTypes().get(0));
                    continue block8;
                }
                case LAST_VALUE: {
                    fixed.add(name, (DataType)fixed.getTypes().get(fixed.size() - 1));
                    continue block8;
                }
            }
            throw new IllegalStateException("Unhandled filler type: " + (Object)((Object)this.m_FillerType));
        }
        return fixed;
    }

    @Override
    public List<Object>[] generateRows(Timeseries timeseries) {
        List<Object>[] base = this.m_Generator.generateRows(timeseries);
        ArrayList[] result = new ArrayList[base.length];
        for (int i = 0; i < base.length; ++i) {
            ArrayList<Object> fixed = new ArrayList<Object>(base[i]);
            while (fixed.size() > this.m_NumFeatures) {
                if (this.m_FillerType == FillerType.FIRST_VALUE) {
                    fixed.remove(0);
                    continue;
                }
                fixed.remove(fixed.size() - 1);
            }
            block10: while (fixed.size() < this.m_NumFeatures) {
                switch (this.m_FillerType) {
                    case MISSING_BOOLEAN: 
                    case MISSING_STRING: 
                    case MISSING_NUMERIC: {
                        fixed.add(null);
                        continue block10;
                    }
                    case FILLER_BOOLEAN: {
                        fixed.add(this.m_FillerBoolean);
                        continue block10;
                    }
                    case FILLER_STRING: {
                        fixed.add(this.m_FillerString);
                        continue block10;
                    }
                    case FILLER_NUMERIC: {
                        fixed.add(this.m_FillerNumeric);
                        continue block10;
                    }
                    case FIRST_VALUE: {
                        if (fixed.size() > 0) {
                            fixed.add(0, fixed.get(0));
                            continue block10;
                        }
                        fixed.add(null);
                        continue block10;
                    }
                    case LAST_VALUE: {
                        if (fixed.size() > 0) {
                            fixed.add(fixed.get(fixed.size() - 1));
                            continue block10;
                        }
                        fixed.add(null);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unhandled filler type: " + (Object)((Object)this.m_FillerType));
            }
            result[i] = fixed;
        }
        return result;
    }

    public static enum FillerType {
        MISSING_NUMERIC,
        MISSING_STRING,
        MISSING_BOOLEAN,
        FILLER_NUMERIC,
        FILLER_STRING,
        FILLER_BOOLEAN,
        FIRST_VALUE,
        LAST_VALUE;

    }
}

