/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.core.DateFormat;
import adams.data.container.AbstractDataPoint;
import adams.data.container.DataPoint;
import java.util.Date;

public class TimeseriesPoint
extends AbstractDataPoint {
    private static final long serialVersionUID = 2381133774648848800L;
    protected static DateFormat m_DateFormat;
    protected Date m_Timestamp;
    protected double m_Value;

    public TimeseriesPoint() {
        this(new Date(), 0.0);
    }

    public TimeseriesPoint(Date timestamp, double value) {
        this.setTimestamp(timestamp);
        this.setValue(value);
    }

    protected synchronized DateFormat getDateFormat() {
        if (m_DateFormat == null) {
            m_DateFormat = new DateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return m_DateFormat;
    }

    public void setTimestamp(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("Timestamp cannot be null!");
        }
        this.m_Timestamp = value;
    }

    public Date getTimestamp() {
        return this.m_Timestamp;
    }

    public void setValue(double value) {
        this.m_Value = value;
    }

    public double getValue() {
        return this.m_Value;
    }

    public int compareTo(Object o) {
        TimeseriesPoint t = (TimeseriesPoint)((Object)o);
        return this.getTimestamp().compareTo(t.getTimestamp());
    }

    public void assign(DataPoint other) {
        super.assign(other);
        TimeseriesPoint point = (TimeseriesPoint)other;
        this.setTimestamp((Date)point.getTimestamp().clone());
        this.setValue(point.getValue());
    }

    public String toString() {
        return this.getDateFormat().format(this.m_Timestamp) + ": " + this.m_Value;
    }
}

