/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.SQLF;
import adams.db.SQLStatement;
import adams.db.SQLUtils;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractDbSource;
import adams.flow.standalone.DatabaseConnectionProvider;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;

public class TimeseriesDbReader
extends AbstractDbSource {
    private static final long serialVersionUID = -1030024345072684197L;
    protected SQLStatement m_SQL;
    protected String m_ColumnID;
    protected int m_ColumnIDType;
    protected int m_ColumnIDIndex;
    protected String m_ColumnTimestamp;
    protected int m_ColumnTimestampType;
    protected int m_ColumnTimestampIndex;
    protected String m_ColumnValue;
    protected int m_ColumnValueType;
    protected int m_ColumnValueIndex;
    protected Timeseries m_Timeseries;
    protected transient ResultSet m_ResultSet;

    public String globalInfo() {
        return "Outputs timeseries containers generated from an SQL SELECT statement.\nA new container is started, whenever the value of the ID column changes (hence you need to ensure that the data is ordered on this column).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", (Object)new SQLStatement("select id,timestamp,value from table order by id"));
        this.m_OptionManager.add("column-id", "columnID", (Object)"");
        this.m_OptionManager.add("column-timestamp", "columnTimestamp", (Object)"");
        this.m_OptionManager.add("column-value", "columnValue", (Object)"");
    }

    protected void reset() {
        super.reset();
        this.m_Timeseries = null;
        this.m_ColumnIDType = 1111;
        this.m_ColumnIDIndex = -1;
        this.m_ColumnTimestampType = 1111;
        this.m_ColumnTimestampIndex = -1;
        this.m_ColumnValueType = 1111;
        this.m_ColumnValueIndex = -1;
        SQLUtils.closeAll((ResultSet)this.m_ResultSet);
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement that selects the timeseries data.";
    }

    public void setColumnID(String value) {
        this.m_ColumnID = value;
        this.reset();
    }

    public String getColumnID() {
        return this.m_ColumnID;
    }

    public String columnIDTipText() {
        return "The name of the column containing the ID that distinguishes the timeseries (accepted types: numeric, string); if left empty, the first string column from the SQL statement is used.";
    }

    public void setColumnTimestamp(String value) {
        this.m_ColumnTimestamp = value;
        this.reset();
    }

    public String getColumnTimestamp() {
        return this.m_ColumnTimestamp;
    }

    public String columnTimestampTipText() {
        return "The name of the column containing the timestamp for a data point (accepted types: integer, date, time, datetime, timestamp); if left empty, the first date-like column from the SQL statement is used.";
    }

    public void setColumnValue(String value) {
        this.m_ColumnValue = value;
        this.reset();
    }

    public String getColumnValue() {
        return this.m_ColumnValue;
    }

    public String columnValueTipText() {
        return "The name of the column containing the value for a data point (accepted types: numeric); if left empty, the first numeric column from the SQL statement is used.";
    }

    public Class[] generates() {
        return new Class[]{Timeseries.class};
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((Actor)this, DatabaseConnectionProvider.class, (AbstractDatabaseConnection)this.getDefaultDatabaseConnection());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"SQL", (Object)Shortening.shortenEnd((String)this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), (int)50));
    }

    protected TimeseriesPoint readDataPoint() throws Exception {
        Date timestamp;
        if (SQLUtils.isInteger((int)this.m_ColumnTimestampIndex)) {
            timestamp = new Date(this.m_ResultSet.getInt(this.m_ColumnTimestampIndex));
        } else if (this.m_ColumnTimestampType == 91) {
            timestamp = this.m_ResultSet.getDate(this.m_ColumnTimestampIndex);
        } else if (this.m_ColumnTimestampType == 92) {
            timestamp = new Date(this.m_ResultSet.getTime(this.m_ColumnTimestampIndex).getTime());
        } else if (this.m_ColumnTimestampType == 93) {
            timestamp = new Date(this.m_ResultSet.getTimestamp(this.m_ColumnTimestampIndex).getTime());
        } else {
            throw new IllegalStateException("Unhandled column type: " + this.m_ColumnTimestampType);
        }
        double val = this.m_ResultSet.getDouble(this.m_ColumnValueIndex);
        TimeseriesPoint result = new TimeseriesPoint(timestamp, val);
        return result;
    }

    protected Timeseries read() throws Exception {
        Timeseries result = this.m_Timeseries;
        boolean dataRead = false;
        String id = null;
        String idOld = null;
        boolean finished = true;
        if (this.m_Timeseries != null) {
            id = this.m_Timeseries.getID();
        }
        while (this.m_ResultSet.next()) {
            dataRead = true;
            idOld = id;
            id = this.m_ResultSet.getObject(this.m_ColumnIDIndex).toString();
            TimeseriesPoint point = this.readDataPoint();
            if (!id.equals(idOld)) {
                this.m_Timeseries = new Timeseries();
                this.m_Timeseries.setID(id);
                this.m_Timeseries.add((DataPoint)point);
                finished = false;
                break;
            }
            result.add((DataPoint)point);
        }
        if (finished) {
            this.m_Timeseries = null;
            if (dataRead) {
                SQLUtils.closeAll((ResultSet)this.m_ResultSet);
                this.m_ResultSet = null;
            }
        }
        if (!dataRead) {
            this.m_Timeseries = null;
            result = null;
            SQLUtils.closeAll((ResultSet)this.m_ResultSet);
            this.m_ResultSet = null;
        }
        return result;
    }

    protected void analyzeColumns() throws Exception {
        ResultSetMetaData meta = this.m_ResultSet.getMetaData();
        this.m_ColumnIDType = 1111;
        this.m_ColumnIDIndex = -1;
        this.m_ColumnTimestampType = 1111;
        this.m_ColumnTimestampIndex = -1;
        this.m_ColumnValueType = 1111;
        this.m_ColumnValueIndex = -1;
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            String col = meta.getColumnName(i);
            int type = meta.getColumnType(i);
            if (this.m_ColumnIDIndex == -1 && (this.m_ColumnID.isEmpty() && SQLUtils.isString((int)type) || col.toLowerCase().equals(this.m_ColumnID.toLowerCase()))) {
                this.m_ColumnIDIndex = i;
                this.m_ColumnIDType = type;
                continue;
            }
            if (this.m_ColumnTimestampIndex == -1 && (this.m_ColumnTimestamp.isEmpty() && SQLUtils.isDate((int)type) || col.toLowerCase().equals(this.m_ColumnTimestamp.toLowerCase()))) {
                this.m_ColumnTimestampIndex = i;
                this.m_ColumnTimestampType = type;
                continue;
            }
            if (this.m_ColumnValueIndex != -1 || (!this.m_ColumnValue.isEmpty() || !SQLUtils.isNumeric((int)type)) && !col.toLowerCase().equals(this.m_ColumnValue.toLowerCase())) continue;
            this.m_ColumnValueIndex = i;
            this.m_ColumnValueType = type;
        }
        if (this.m_ColumnIDIndex == -1) {
            if (this.m_ColumnID.isEmpty()) {
                throw new IllegalStateException("No suitable 'ID' column found in result set!");
            }
            throw new IllegalStateException("ID column '" + this.m_ColumnID + "' not found in result set!");
        }
        if (!SQLUtils.isNumeric((int)this.m_ColumnIDType) && !SQLUtils.isString((int)this.m_ColumnIDType)) {
            throw new IllegalStateException("ID column '" + this.m_ColumnID + "' must be a numeric or string type: " + this.m_ColumnIDType);
        }
        if (this.m_ColumnTimestampIndex == -1) {
            if (this.m_ColumnTimestamp.isEmpty()) {
                throw new IllegalStateException("No suitable 'timestamp' column found in result set!");
            }
            throw new IllegalStateException("Timestamp column '" + this.m_ColumnTimestamp + "' not found in result set!");
        }
        if (!SQLUtils.isInteger((int)this.m_ColumnTimestampType) && this.m_ColumnTimestampType != 91 && this.m_ColumnTimestampType != 92 && this.m_ColumnTimestampType != 93) {
            throw new IllegalStateException("Timestamp column '" + this.m_ColumnTimestamp + "' must be a integer or date-related type: " + this.m_ColumnTimestampType);
        }
        if (this.m_ColumnValueIndex == -1) {
            if (this.m_ColumnValue.isEmpty()) {
                throw new IllegalStateException("No suitable 'value' column found in result set!");
            }
            throw new IllegalStateException("Value column '" + this.m_ColumnValue + "' not found in result set!");
        }
        if (!SQLUtils.isNumeric((int)this.m_ColumnValueType)) {
            throw new IllegalStateException("Value column '" + this.m_ColumnValue + "' must be a numeric type: " + this.m_ColumnValueType);
        }
    }

    protected String queryDatabase() {
        String result = null;
        String query = null;
        try {
            query = this.m_SQL.getValue();
            query = this.getVariables().expand(query);
            this.m_ResultSet = SQLF.getSingleton((AbstractDatabaseConnection)this.m_DatabaseConnection).getResultSet(query);
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("SQL: " + query);
            }
            this.analyzeColumns();
            this.read();
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute statement: " + (query == null ? this.m_SQL : query), e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Timeseries != null;
    }

    public Token output() {
        Token result = null;
        try {
            Timeseries series = this.read();
            if (series != null) {
                result = new Token((Object)series);
            }
        }
        catch (Exception e) {
            this.handleException("Failed to read timeseries data!", e);
            result = null;
        }
        return result;
    }

    public void wrapUp() {
        SQLUtils.closeAll((ResultSet)this.m_ResultSet);
        this.m_Timeseries = null;
        super.wrapUp();
    }
}

