/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.wekaforecastersetup;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.TimeseriesLOWESSBased;
import adams.flow.source.wekaforecastersetup.AbstractForecasterGenerator;
import adams.flow.source.wekaforecastersetup.WekaForecasterGenerator;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.BaselineAdjustedForecaster;

public class BaselineAdjustedForecasterGenerator
extends AbstractForecasterGenerator {
    private static final long serialVersionUID = -6919031737595447726L;
    protected AbstractBaselineCorrection m_Correction;
    protected AbstractForecasterGenerator m_Baseline;
    protected AbstractForecasterGenerator m_Periodicity;

    public String globalInfo() {
        return "Outputs a configured instance of a baseline-adjusted Forecaster.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("correction", "correction", (Object)new TimeseriesLOWESSBased());
        this.m_OptionManager.add("baseline", "baseline", (Object)new WekaForecasterGenerator());
        this.m_OptionManager.add("periodicity", "periodicity", (Object)new WekaForecasterGenerator());
    }

    public void setCorrection(AbstractBaselineCorrection value) {
        this.m_Correction = value;
        this.reset();
    }

    public AbstractBaselineCorrection getCorrection() {
        return this.m_Correction;
    }

    public String correctionTipText() {
        return "The baseline correction scheme to use.";
    }

    public void setBaseline(AbstractForecasterGenerator value) {
        this.m_Baseline = value;
        this.reset();
    }

    public AbstractForecasterGenerator getBaseline() {
        return this.m_Baseline;
    }

    public String baselineTipText() {
        return "The forecaster generator for the baseline data.";
    }

    public void setPeriodicity(AbstractForecasterGenerator value) {
        this.m_Periodicity = value;
        this.reset();
    }

    public AbstractForecasterGenerator getPeriodicity() {
        return this.m_Periodicity;
    }

    public String periodicityTipText() {
        return "The forecaster generator for the periodicity data.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"correction", (Object)this.m_Correction, (String)"correction: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"baseline", (Object)((Object)this.m_Baseline), (String)", baseline: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"periodicity", (Object)((Object)this.m_Periodicity), (String)", periodicity: ");
        return result;
    }

    @Override
    public AbstractForecaster generate() throws Exception {
        BaselineAdjustedForecaster result = new BaselineAdjustedForecaster();
        result.setCorrection(this.m_Correction.shallowCopy());
        result.setBaseline(this.m_Baseline.generate());
        result.setPeriodicity(this.m_Periodicity.generate());
        return result;
    }
}

