/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.data.timeseries.AbstractTimeseriesFeatureGenerator;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.Values;
import adams.event.VariableChangeEvent;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.FeatureGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class TimeseriesFeatureGenerator
extends AbstractTransformer
implements FeatureGenerator<AbstractTimeseriesFeatureGenerator> {
    private static final long serialVersionUID = -7637423921443102660L;
    public static final String BACKUP_QUEUE = "queue";
    public static final String BACKUP_ALGORITHM = "algorithm";
    protected AbstractTimeseriesFeatureGenerator m_Algorithm;
    protected transient AbstractTimeseriesFeatureGenerator m_ActualAlgorithm;
    protected VariableName m_VariableName;
    protected ArrayList m_Queue;

    public String globalInfo() {
        return "Applies a timeseries feature generator to the incoming timeseries and outputs the generated features.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_ALGORITHM, BACKUP_ALGORITHM, (Object)new Values());
        this.m_OptionManager.add("var-name", "variableName", (Object)new VariableName());
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
        this.m_ActualAlgorithm = null;
    }

    public void setAlgorithm(AbstractTimeseriesFeatureGenerator value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractTimeseriesFeatureGenerator getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The feature generation algorithm to use.";
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to monitor for resetting trainable batch filters.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_ALGORITHM, (Object)this.m_Algorithm, (String)"algorithm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"variableName", (Object)this.m_VariableName.paddedValue(), (String)", monitor: ");
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_QUEUE);
        this.pruneBackup(BACKUP_ALGORITHM);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_QUEUE, this.m_Queue);
        if (this.m_ActualAlgorithm != null) {
            result.put(BACKUP_ALGORITHM, this.m_ActualAlgorithm);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (ArrayList)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        if (state.containsKey(BACKUP_ALGORITHM)) {
            this.m_ActualAlgorithm = (AbstractTimeseriesFeatureGenerator)state.get(BACKUP_ALGORITHM);
            state.remove(BACKUP_ALGORITHM);
        }
        super.restoreState(state);
    }

    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if ((e.getType() == VariableChangeEvent.Type.MODIFIED || e.getType() == VariableChangeEvent.Type.ADDED) && e.getName().equals(this.m_VariableName.getValue())) {
            this.m_ActualAlgorithm = null;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Reset 'algorithm'");
            }
        }
    }

    public Class[] accepts() {
        return new Class[]{Timeseries.class};
    }

    public Class[] generates() {
        if (this.m_Algorithm == null) {
            return new Class[]{Object.class};
        }
        return new Class[]{this.m_Algorithm.getRowFormat()};
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        try {
            if (this.m_ActualAlgorithm == null) {
                this.m_ActualAlgorithm = (AbstractTimeseriesFeatureGenerator)ObjectCopyHelper.copyObject((Object)this.m_Algorithm);
            }
            this.m_Queue.addAll(Arrays.asList(this.m_ActualAlgorithm.generate((Timeseries)((Object)this.m_InputToken.getPayload()))));
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate features: ", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }

    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }
}

