/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.data.timeseries.PeriodicityType;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.PeriodicityTickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesXAxisPanelOptions;
import adams.gui.visualization.timeseries.TimeseriesPanel;
import java.awt.Container;

public class DefaultTimeseriesXAxisPanelOptions
extends AbstractTimeseriesXAxisPanelOptions {
    private static final long serialVersionUID = -1774995113138870653L;
    protected PeriodicityType m_Periodicity;

    public String globalInfo() {
        return "Encapsulates options for the X axis in a timeseries plot.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("periodicity", "periodicity", (Object)PeriodicityType.NONE);
    }

    public void setPeriodicity(PeriodicityType value) {
        this.m_Periodicity = value;
        this.reset();
    }

    public PeriodicityType getPeriodicity() {
        return this.m_Periodicity;
    }

    public String periodicityTipText() {
        return "The type of periodicity to use for the background.";
    }

    public void configure(PlotPanel plot, Axis axis) {
        super.configure(plot, axis);
        Object parent = GUIHelper.getParent((Container)plot, TimeseriesPanel.class);
        if (parent != null) {
            TimeseriesPanel panel = (TimeseriesPanel)((Object)parent);
            panel.getPeriodicityPaintlet().setPeriodicity(this.m_Periodicity);
        }
        if (plot.getAxis(axis).getTickGenerator() instanceof PeriodicityTickGenerator) {
            ((PeriodicityTickGenerator)plot.getAxis(axis).getTickGenerator()).setPeriodicity(this.m_Periodicity);
        }
    }
}

