/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.SortedList;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesUtils;
import java.util.Date;
import java.util.List;

public class TimeseriesChangeResolution
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected double m_Interval;
    protected int m_Polynomial;

    public String globalInfo() {
        return "Generates a new timeseries with a (user-defined) fixed-length interval between data points.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("interval", "interval", (Object)30.0, (Number)0.01, null);
        this.m_OptionManager.add("polynomial", "polynomial", (Object)2, (Number)1, null);
    }

    public void setInterval(double value) {
        if (value > 0.0) {
            this.m_Interval = value;
            this.reset();
        } else {
            this.getLogger().warning("Interval must be > 0, provided: " + value);
        }
    }

    public double getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The new, fixed-length interval between data points in seconds.";
    }

    public void setPolynomial(int value) {
        this.m_Polynomial = value;
        this.reset();
    }

    public int getPolynomial() {
        return this.m_Polynomial;
    }

    public String polynomialTipText() {
        return "The polynomial for interpolation.";
    }

    protected List<TimeseriesPoint> getClosestPoints(long timestamp, List<TimeseriesPoint> data, int numpoints) {
        SortedList result = new SortedList();
        int found = 0;
        int pos = TimeseriesUtils.findClosestTimestamp(data, new Date(timestamp));
        result.add((TimeseriesPoint)((Object)data.get(pos).getClone()));
        int foundmin = pos;
        int foundmax = pos;
        ++found;
        while (found < numpoints) {
            double minusposdiff = Double.MAX_VALUE;
            double plusposdiff = Double.MAX_VALUE;
            if (foundmin - 1 > 0) {
                minusposdiff = Math.abs(timestamp - data.get(foundmin - 1).getTimestamp().getTime());
            }
            if (foundmax + 1 < data.size()) {
                plusposdiff = Math.abs(timestamp - data.get(foundmax + 1).getTimestamp().getTime());
            }
            if (minusposdiff < plusposdiff) {
                result.add((TimeseriesPoint)((Object)data.get(foundmin - 1).getClone()));
                --foundmin;
            } else {
                result.add((TimeseriesPoint)((Object)data.get(foundmax + 1).getClone()));
                ++foundmax;
            }
            ++found;
        }
        return result;
    }

    protected double L(double timestamp, List<TimeseriesPoint> closest, int m) {
        int k;
        double num = 1.0;
        double den = 1.0;
        for (k = 0; k < closest.size(); ++k) {
            if (k == m) continue;
            num *= timestamp - (double)closest.get(k).getTimestamp().getTime();
        }
        for (k = 0; k < closest.size(); ++k) {
            if (k == m) continue;
            den *= (double)closest.get(m).getTimestamp().getTime() - (double)closest.get(k).getTimestamp().getTime();
        }
        return num / den;
    }

    protected double interpolate(double timestamp, List<TimeseriesPoint> closest, int poly) {
        double result = 0.0;
        for (int i = 0; i <= poly; ++i) {
            result += this.L(timestamp, closest, i) * closest.get(i).getValue();
        }
        return result;
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        List list = data.toList();
        long step = Math.round(this.m_Interval * 1000.0);
        long last = ((TimeseriesPoint)((Object)list.get(list.size() - 1))).getTimestamp().getTime();
        for (long timestamp = ((TimeseriesPoint)((Object)list.get(0))).getTimestamp().getTime(); timestamp < last; timestamp += step) {
            List<TimeseriesPoint> closest = this.getClosestPoints(timestamp, list, this.m_Polynomial + 1);
            double value = this.interpolate(timestamp, closest, closest.size() - 1);
            result.add((DataPoint)new TimeseriesPoint(new Date(timestamp), value));
        }
        return result;
    }
}

