/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataPoint;
import adams.data.filter.AbstractEquiDistance;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesPointComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TimeseriesEquiDistance
extends AbstractEquiDistance<Timeseries> {
    private static final long serialVersionUID = -17911247313401753L;

    public String globalInfo() {
        return "A filter for interpolating the values of a time series. One can either specify a fixed number of points or just use the same amount of points as currently in the input data.";
    }

    protected TimeseriesPoint interpolate(long time, TimeseriesPoint left, TimeseriesPoint right) {
        double wavenodiff = right.getTimestamp().getTime() - left.getTimestamp().getTime();
        double percLeft = 1.0 - (double)(time - left.getTimestamp().getTime()) / wavenodiff;
        double percRight = 1.0 - (double)(right.getTimestamp().getTime() - time) / wavenodiff;
        TimeseriesPoint result = new TimeseriesPoint(new Date(time), left.getValue() * percLeft + right.getValue() * percRight);
        return result;
    }

    protected Timeseries processData(Timeseries data) {
        int index;
        int i;
        int actualPoints;
        Timeseries tmpData = data;
        List orderedData = tmpData.toList();
        Timeseries result = tmpData.getHeader();
        if (this.m_NumPoints == -1) {
            actualPoints = orderedData.size();
        } else {
            actualPoints = this.m_NumPoints;
            if (!this.m_AllowOversampling && actualPoints > orderedData.size()) {
                actualPoints = orderedData.size();
            }
        }
        double averageSpacing = ((TimeseriesPoint)((Object)orderedData.get(orderedData.size() - 1))).getTimestamp().getTime() - ((TimeseriesPoint)((Object)orderedData.get(0))).getTimestamp().getTime();
        averageSpacing /= (double)(actualPoints - 1);
        result.add((DataPoint)((TimeseriesPoint)((Object)((TimeseriesPoint)((Object)orderedData.get(0))).getClone())));
        result.add((DataPoint)((TimeseriesPoint)((Object)((TimeseriesPoint)((Object)orderedData.get(orderedData.size() - 1))).getClone())));
        ArrayList<Integer> exact = new ArrayList<Integer>();
        TimeseriesPointComparator comp = new TimeseriesPointComparator();
        long timeStart = ((TimeseriesPoint)((Object)orderedData.get(0))).getTimestamp().getTime();
        for (i = 1; i < actualPoints - 1; ++i) {
            long time = (long)((double)timeStart + (double)i * averageSpacing);
            index = Collections.binarySearch(orderedData, new TimeseriesPoint(new Date(time), 0.0), comp);
            if (index >= 0) {
                exact.add(result.size());
                result.add((DataPoint)((TimeseriesPoint)((Object)((TimeseriesPoint)((Object)orderedData.get(index))).getClone())));
                continue;
            }
            result.add((DataPoint)this.interpolate(time, (TimeseriesPoint)((Object)orderedData.get(-index - 2)), (TimeseriesPoint)((Object)orderedData.get(-index - 1))));
        }
        orderedData = result.toList();
        for (i = 0; i < exact.size(); ++i) {
            index = (Integer)exact.get(i);
            TimeseriesPoint newPoint = index < orderedData.size() - 1 ? this.interpolate(((TimeseriesPoint)((Object)orderedData.get(index))).getTimestamp().getTime(), (TimeseriesPoint)((Object)orderedData.get(index - 1)), (TimeseriesPoint)((Object)orderedData.get(index + 1))) : this.interpolate(((TimeseriesPoint)((Object)orderedData.get(index))).getTimestamp().getTime(), (TimeseriesPoint)((Object)orderedData.get(index - 1)), (TimeseriesPoint)((Object)orderedData.get(index)));
            double value = (newPoint.getValue() + ((TimeseriesPoint)((Object)orderedData.get(index))).getValue()) / 2.0;
            ((TimeseriesPoint)((Object)orderedData.get(index))).setValue(value);
        }
        return result;
    }
}

