/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.data.outlier.AbstractOutlierDetector;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.ArrayList;
import java.util.List;

public class TimeseriesMinPoints
extends AbstractOutlierDetector<Timeseries> {
    private static final long serialVersionUID = -3670792009048485874L;
    protected double m_NumPoints;
    protected double m_MinValue;

    public String globalInfo() {
        return "Ensures that a minimum number of points in the timeseries have the specified minimum value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-points", "numPoints", (Object)0.5, (Number)0.0, null);
        this.m_OptionManager.add("min-value", "minValue", (Object)0.0, null, null);
    }

    public void setNumPoints(double value) {
        if (value > 0.0) {
            this.m_NumPoints = value;
            this.reset();
        } else {
            this.getLogger().warning("numPoints must be >0, provided: " + value);
        }
    }

    public double getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The minimum number of points that must have at least the minimum value; if less than 1 it is interpreted as percentage, otherwise as an absolute number.";
    }

    public void setMinValue(double value) {
        this.m_MinValue = value;
        this.reset();
    }

    public double getMinValue() {
        return this.m_MinValue;
    }

    public String minValueTipText() {
        return "The minimum value that the data points must satisfy.";
    }

    protected List<String> processData(Timeseries data) {
        ArrayList<String> result = new ArrayList<String>();
        double min = this.m_NumPoints < 1.0 ? (double)data.size() * this.m_NumPoints : this.m_NumPoints;
        int count = 0;
        for (int i = 0; i < data.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)data.toList().get(i));
            if (!(point.getValue() >= this.m_MinValue)) continue;
            ++count;
        }
        if ((double)count < min) {
            result.add("Not enough data points with at least " + this.m_MinValue + ": " + count + " < " + min);
        }
        return result;
    }
}

