/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Index;
import adams.core.base.BaseDateTime;
import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeseriesTimestampCheck
extends AbstractOutlierDetector<Timeseries> {
    private static final long serialVersionUID = -5300001549269138646L;
    protected Index m_Index;
    protected TimestampCondition m_Condition;
    protected BaseDateTime m_Timestamp;

    public String globalInfo() {
        return "Checks whether the timestamp with the specified index meets the condition (eg before or after the supplied timestamp).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
        this.m_OptionManager.add("condition", "condition", (Object)TimestampCondition.AFTER);
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new BaseDateTime("-INF"));
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the timestamp to use for the check.";
    }

    public void setCondition(TimestampCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    public TimestampCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition that the selected timestamp must meet.";
    }

    public void setTimestamp(BaseDateTime value) {
        this.m_Timestamp = value;
        this.reset();
    }

    public BaseDateTime getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The timestamp to use in the check.";
    }

    protected void checkData(Timeseries data) {
        super.checkData((DataContainer)data);
        this.m_Index.setMax(data.size());
        if (this.m_Index.getIntIndex() == -1) {
            throw new IllegalStateException("Invalid index: " + this.m_Index);
        }
    }

    protected List<String> processData(Timeseries data) {
        ArrayList<String> result = new ArrayList<String>();
        DateFormat dformat = DateUtils.getTimestampFormatter();
        String msg = null;
        List points = data.toList();
        TimeseriesPoint point = (TimeseriesPoint)((Object)points.get(this.m_Index.getIntIndex()));
        Date timestamp = this.m_Timestamp.dateValue();
        switch (this.m_Condition) {
            case BEFORE: {
                if (DateUtils.isBefore((Date)timestamp, (Date)point.getTimestamp())) break;
                msg = "Timestamp at '" + this.m_Index + "' is not before supplied timestamp: " + dformat.format(point.getTimestamp()) + " > " + dformat.format(timestamp);
                break;
            }
            case AFTER: {
                if (DateUtils.isAfter((Date)timestamp, (Date)point.getTimestamp())) break;
                msg = "Timestamp at '" + this.m_Index + "' is not after supplied timestamp: " + dformat.format(point.getTimestamp()) + " < " + dformat.format(timestamp);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled timestamp condition: " + (Object)((Object)this.m_Condition));
            }
        }
        if (msg != null) {
            result.add(msg);
            if (this.isLoggingEnabled()) {
                this.getLogger().info(data.getDatabaseID() + " - " + ((Object)((Object)this)).getClass().getName() + ": " + msg);
            }
        }
        return result;
    }

    public static enum TimestampCondition {
        BEFORE,
        AFTER;

    }
}

