/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.base.BaseDateTime;
import adams.data.filter.AbstractTimeseriesFilterTestCase;
import adams.data.filter.Filter;
import adams.data.filter.TimeseriesShiftTimestamps;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.timeseries.Timeseries;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TimeseriesShiftTimestampsTest
extends AbstractTimeseriesFilterTestCase {
    public TimeseriesShiftTimestampsTest(String name) {
        super(name);
    }

    public Filter<Timeseries> getFilter() {
        return new TimeseriesShiftTimestamps();
    }

    protected String[] getRegressionInputFiles() {
        return new String[]{"wine_report.sts", "wine_report.sts", "wine_report.sts"};
    }

    protected Filter[] getRegressionSetups() {
        TimeseriesShiftTimestamps[] result = new TimeseriesShiftTimestamps[3];
        result[0] = new TimeseriesShiftTimestamps();
        result[0].setNewTimestamp(new BaseDateTime("2000-01-01 00:00:00"));
        result[0].setSuppliedTimestamp(new BaseDateTime("2000-01-01 00:00:00"));
        result[1] = new TimeseriesShiftTimestamps();
        result[1].setSource(TimeseriesShiftTimestamps.TimestampSource.SUPPLIED_TIMESTAMP);
        result[1].setSuppliedTimestamp(new BaseDateTime("2013-04-03 00:00:00"));
        result[1].setNewTimestamp(new BaseDateTime("2000-01-01 00:00:00"));
        result[2] = new TimeseriesShiftTimestamps();
        result[2].setSource(TimeseriesShiftTimestamps.TimestampSource.REPORT_FIELD);
        result[2].setCustomFormat("yyyy-MM-dd");
        result[2].setReportField(new Field("loadvesseldate", DataType.STRING));
        result[2].setNewTimestamp(new BaseDateTime("2000-01-01 00:00:00"));
        return result;
    }

    public static Test suite() {
        return new TestSuite(TimeseriesShiftTimestampsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TimeseriesShiftTimestampsTest.runTest((Test)TimeseriesShiftTimestampsTest.suite());
    }
}

