/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractTimeseriesReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.timeseries.AbstractTimeseriesFeatureGenerator;
import adams.data.timeseries.Timeseries;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.List;

public abstract class AbstractTimeseriesFeatureGeneratorTestCase
extends AdamsTestCase {
    public AbstractTimeseriesFeatureGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/timeseries/data");
    }

    protected Timeseries[] load(String filename, AbstractTimeseriesReader reader) {
        List result = null;
        this.m_TestHelper.copyResourceToTmp(filename);
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        result = reader.read();
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result.toArray(new Timeseries[result.size()]);
    }

    protected Object[][] process(Timeseries[] timeseries, AbstractTimeseriesFeatureGenerator scheme) {
        Object[][] result = new Object[timeseries.length][];
        for (int i = 0; i < timeseries.length; ++i) {
            result[i] = scheme.generate(timeseries[i]);
        }
        return result;
    }

    protected String toString(Object obj) {
        if (obj instanceof Row) {
            Row row = (Row)obj;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < row.getCellCount(); ++i) {
                Cell cell;
                if (i > 0) {
                    result.append(",");
                }
                if ((cell = row.getCell(i)).isNumeric()) {
                    result.append(Utils.doubleToString((double)cell.toDouble(), (int)6));
                    continue;
                }
                result.append(cell.getContent());
            }
            return result.toString();
        }
        return obj.toString();
    }

    protected boolean save(Object[][] data, String filename) {
        boolean result = true;
        boolean first = true;
        Object[][] objectArray = data;
        int n = objectArray.length;
        block0: for (int i = 0; i < n; ++i) {
            Object[] objects;
            for (Object obj : objects = objectArray[i]) {
                result = FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)(this.toString(obj) + "\n"), (boolean)first);
                if (!result) continue block0;
                first = false;
            }
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractTimeseriesReader[] getRegressionInputReaders();

    protected abstract AbstractTimeseriesFeatureGenerator[] getRegressionSetups();

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
        }
        result = (String)result + ".txt";
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        AbstractTimeseriesReader[] readers = this.getRegressionInputReaders();
        String[] output = new String[input.length];
        AbstractTimeseriesFeatureGenerator[] setups = this.getRegressionSetups();
        AbstractTimeseriesFeatureGeneratorTestCase.assertEquals((String)"Number of files and readers differ!", (int)input.length, (int)readers.length);
        AbstractTimeseriesFeatureGeneratorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            Timeseries[] data = this.load(input[i], readers[i]);
            AbstractTimeseriesFeatureGeneratorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            Object[][] processed = this.process(data, setups[i]);
            AbstractTimeseriesFeatureGeneratorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractTimeseriesFeatureGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractTimeseriesFeatureGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

