/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.container.DataPoint;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.Date;

public class SpreadSheetToTimeseries
extends AbstractConversion {
    private static final long serialVersionUID = 5898182986872208113L;
    protected SpreadSheetColumnIndex m_DateColumn;
    protected SpreadSheetColumnIndex m_ValueColumn;

    public String globalInfo() {
        return "Turns a SpreadSheet object into a Timeseries.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("date-column", "dateColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value-column", "valueColumn", (Object)new SpreadSheetColumnIndex("2"));
    }

    public void setDateColumn(SpreadSheetColumnIndex value) {
        this.m_DateColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getDateColumn() {
        return this.m_DateColumn;
    }

    public String dateColumnTipText() {
        return "The index of the date column in the spreadsheet to use a timestamp for the timeseries data points.";
    }

    public void setValueColumn(SpreadSheetColumnIndex value) {
        this.m_ValueColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getValueColumn() {
        return this.m_ValueColumn;
    }

    public String valueColumnTipText() {
        return "The index of the column with the timeseries values in the dataset.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Timeseries.class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet input = (SpreadSheet)this.m_Input;
        this.m_DateColumn.setData((Object)input);
        int indexDate = this.m_DateColumn.getIntIndex();
        if (indexDate == -1) {
            throw new IllegalStateException("Failed to located date column: " + this.m_DateColumn.getIndex());
        }
        this.m_ValueColumn.setData((Object)input);
        int indexValue = this.m_ValueColumn.getIntIndex();
        if (indexValue == -1) {
            throw new IllegalStateException("Failed to located value column: " + this.m_ValueColumn.getIndex());
        }
        Timeseries result = new Timeseries((String)(input.getName() != null ? input.getName() + "-" : "") + input.getColumnName(indexValue));
        for (int i = 0; i < input.getRowCount(); ++i) {
            DataRow row = input.getRow(i);
            if (!row.hasCell(indexDate) || row.getCell(indexDate).isMissing() || !row.hasCell(indexValue) || row.getCell(indexValue).isMissing()) continue;
            Date timestamp = row.getCell(indexDate).toAnyDateType();
            double value = row.getCell(indexValue).toDouble();
            TimeseriesPoint point = new TimeseriesPoint(timestamp, value);
            result.add((DataPoint)point);
        }
        return result;
    }
}

