/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Index;
import adams.core.Range;
import adams.data.conversion.AbstractConversion;
import adams.flow.container.WekaForecastContainer;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;

public class WekaForecastContainerToArray
extends AbstractConversion {
    private static final long serialVersionUID = 3934411483801077460L;
    protected Index m_Index;
    protected Range m_PredictionRange;

    public String globalInfo() {
        return "Turns a series of predictions of a " + WekaForecastContainer.class.getName() + " container into a Double array.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
        this.m_OptionManager.add("prediction-range", "predictionRange", (Object)new Range("first-last"));
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the timeseries to extract from the container.";
    }

    public void setPredictionRange(Range value) {
        this.m_PredictionRange = value;
        this.reset();
    }

    public Range getPredictionRange() {
        return this.m_PredictionRange;
    }

    public String predictionRangeTipText() {
        return "The range of predictions to convert into an array.";
    }

    public Class accepts() {
        return WekaForecastContainer.class;
    }

    public Class generates() {
        return Double[].class;
    }

    protected Object doConvert() throws Exception {
        WekaForecastContainer forecast = (WekaForecastContainer)((Object)this.m_Input);
        List list = (List)forecast.getValue("Forecasts");
        int index = 0;
        this.m_PredictionRange.setMax(list.size());
        int[] range = this.m_PredictionRange.getIntIndices();
        Double[] result = new Double[range.length];
        boolean first = true;
        for (int i : range) {
            if (first) {
                this.m_Index.setMax(((List)list.get(i)).size());
                index = this.m_Index.getIntIndex();
            }
            result[i] = ((NumericPrediction)((List)list.get(i)).get(index)).predicted();
            first = false;
        }
        return result;
    }
}

