/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Index;
import adams.core.Range;
import adams.core.base.BaseDateTime;
import adams.data.container.DataPoint;
import adams.data.conversion.AbstractConversion;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.container.WekaForecastContainer;
import java.util.Date;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;

public class WekaForecastContainerToTimeseries
extends AbstractConversion {
    private static final long serialVersionUID = 3934411483801077460L;
    protected Index m_Index;
    protected Range m_PredictionRange;
    protected BaseDateTime m_Start;
    protected BaseDateTime m_Interval;

    public String globalInfo() {
        return "Turns a series of predictions of a " + WekaForecastContainer.class.getName() + " container into a " + Timeseries.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
        this.m_OptionManager.add("prediction-range", "predictionRange", (Object)new Range("first-last"));
        this.m_OptionManager.add("start", "start", (Object)this.getDefaultStart());
        this.m_OptionManager.add("interval", "interval", (Object)this.getDefaultInterval());
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the timeseries to extract from the container.";
    }

    public void setPredictionRange(Range value) {
        this.m_PredictionRange = value;
        this.reset();
    }

    public Range getPredictionRange() {
        return this.m_PredictionRange;
    }

    public String predictionRangeTipText() {
        return "The range of predictions to convert into a timeseries.";
    }

    protected BaseDateTime getDefaultStart() {
        return new BaseDateTime("2000-01-01 00:00:00");
    }

    public void setStart(BaseDateTime value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseDateTime getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The start date/time for the timeseries.";
    }

    protected BaseDateTime getDefaultInterval() {
        return new BaseDateTime("START +1 DAY");
    }

    public void setInterval(BaseDateTime value) {
        this.m_Interval = value;
        this.reset();
    }

    public BaseDateTime getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval between timeseries points; START refers to the previous data point.";
    }

    public Class accepts() {
        return WekaForecastContainer.class;
    }

    public Class generates() {
        return Timeseries.class;
    }

    protected Object doConvert() throws Exception {
        WekaForecastContainer forecast = (WekaForecastContainer)((Object)this.m_Input);
        List list = (List)forecast.getValue("Forecasts");
        Timeseries result = new Timeseries();
        int index = 0;
        Date prev = null;
        Date current = null;
        this.m_PredictionRange.setMax(list.size());
        int[] range = this.m_PredictionRange.getIntIndices();
        boolean first = true;
        for (int i : range) {
            if (first) {
                this.m_Index.setMax(((List)list.get(i)).size());
                index = this.m_Index.getIntIndex();
            }
            double pred = ((NumericPrediction)((List)list.get(i)).get(index)).predicted();
            prev = current;
            if (first) {
                current = this.m_Start.dateValue();
            } else {
                this.m_Interval.setStart(prev);
                current = this.m_Interval.dateValue();
            }
            result.add((DataPoint)new TimeseriesPoint(current, pred));
            first = false;
        }
        return result;
    }
}

