/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.RoundingType;
import adams.data.RoundingUtils;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;

public class TimeseriesRound
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected RoundingType m_Type;
    protected int m_NumDecimals;

    public String globalInfo() {
        return "Rounds the values of the timeseries points.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)RoundingType.ROUND);
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)0, (Number)0, null);
    }

    public void setType(RoundingType value) {
        this.m_Type = value;
        this.reset();
    }

    public RoundingType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of rounding to perform.";
    }

    public void setNumDecimals(int value) {
        if (this.getOptionManager().isValid("numDecimals", (Number)value)) {
            this.m_NumDecimals = value;
            this.reset();
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals after the decimal point to use.";
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        for (int i = 0; i < data.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)data.toList().get(i));
            double value = RoundingUtils.apply((RoundingType)this.m_Type, (double)point.getValue(), (int)this.m_NumDecimals);
            result.add((DataPoint)new TimeseriesPoint(point.getTimestamp(), value));
        }
        return result;
    }
}

