/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;

public class TimeseriesShiftValues
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected double m_Amount;

    public String globalInfo() {
        return "Shifts the values of the timeseries by the specified amount (up or down, depending on the sign).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("amount", "amount", (Object)0.0);
    }

    public void setAmount(double value) {
        this.m_Amount = value;
        this.reset();
    }

    public double getAmount() {
        return this.m_Amount;
    }

    public String amountTipText() {
        return "The amount to shift the values by.";
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        for (int i = 0; i < data.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)data.toList().get(i));
            result.add((DataPoint)new TimeseriesPoint(point.getTimestamp(), point.getValue() + this.m_Amount));
        }
        return result;
    }
}

