/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.io.ModelFileHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaForecastContainer;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.DynamicInitializer;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import java.io.PrintStream;
import java.util.List;
import weka.classifiers.timeseries.AbstractForecaster;

public class WekaForecasting
extends AbstractSimpleSource
implements ModelFileHandler,
DynamicInitializer {
    private static final long serialVersionUID = -3019442578354930841L;
    protected PlaceholderFile m_ModelFile;
    protected CallableActorReference m_ModelActor;
    protected AbstractForecaster m_Model;
    protected boolean m_OnTheFly;
    protected int m_NumSteps;

    public String globalInfo() {
        return "Uses a serialized model to perform predictions on the data being passed through.\nThe model can also be obtained from a callable actor, if the model file is pointing to a directory.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("model", "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("model-actor", "modelActor", (Object)new CallableActorReference());
        this.m_OptionManager.add("on-the-fly", "onTheFly", (Object)false);
        this.m_OptionManager.add("num-steps", "numSteps", (Object)1, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_Model = null;
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelFile = value;
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelFile;
    }

    public String modelFileTipText() {
        return "The model file to load (when not pointing to a directory).";
    }

    public void setModelActor(CallableActorReference value) {
        this.m_ModelActor = value;
        this.reset();
    }

    public CallableActorReference getModelActor() {
        return this.m_ModelActor;
    }

    public String modelActorTipText() {
        return "The callable actor to use for obtaining the model in case serialized model file points to a directory; can be a " + WekaModelContainer.class.getName() + " or a " + AbstractForecaster.class.getName() + ".";
    }

    public void setOnTheFly(boolean value) {
        this.m_OnTheFly = value;
        this.reset();
    }

    public boolean getOnTheFly() {
        return this.m_OnTheFly;
    }

    public String onTheFlyTipText() {
        return "If set to true, the model file is not required to be present at set up time (eg if built on the fly), only at execution time.";
    }

    public void setNumSteps(int value) {
        this.m_NumSteps = value;
        this.reset();
    }

    public int getNumSteps() {
        return this.m_NumSteps;
    }

    public String numStepsTipText() {
        return "The number of steps to forecast.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"modelFile", (Object)(this.m_ModelFile.isDirectory() ? this.m_ModelActor : this.m_ModelFile));
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"numSteps", (Object)this.m_NumSteps, (String)", Steps: ");
        return result;
    }

    public Class[] generates() {
        return new Class[]{WekaForecastContainer.class};
    }

    protected String setUpModel() {
        String result = null;
        if (this.m_ModelFile.isDirectory()) {
            try {
                MessageCollection errors = new MessageCollection();
                Object obj = CallableActorHelper.getSetup(null, (CallableActorReference)this.m_ModelActor, (Actor)this, (MessageCollection)errors);
                if (obj == null) {
                    if (!errors.isEmpty()) {
                        result = errors.toString();
                    }
                } else if (obj instanceof WekaModelContainer) {
                    this.m_Model = (AbstractForecaster)((WekaModelContainer)obj).getValue("Model");
                } else if (obj instanceof AbstractForecaster) {
                    this.m_Model = (AbstractForecaster)obj;
                }
            }
            catch (Exception e) {
                this.m_Model = null;
                result = this.handleException("Failed to obtain model from callable actor '" + this.m_ModelActor + "': ", e);
            }
        } else {
            try {
                this.m_Model = (AbstractForecaster)SerializationHelper.read((String)this.m_ModelFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.m_Model = null;
                result = this.handleException("Failed to load model from '" + this.m_ModelFile + "': ", e);
            }
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_OnTheFly) {
            result = this.setUpModel();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_OnTheFly && this.m_Model == null && (result = this.setUpModel()) != null) {
            return result;
        }
        try {
            List forecasts = this.m_Model.forecast(this.m_NumSteps, new PrintStream[0]);
            WekaForecastContainer cont = new WekaForecastContainer(this.m_Model, forecasts);
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to forecast!", e);
        }
        return result;
    }
}

