/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.wekaforecastersetup;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.LagMakerOptions;
import adams.flow.source.wekaforecastersetup.AbstractForecasterGenerator;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegressionJ;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.WekaForecaster;

public class WekaForecasterGenerator
extends AbstractForecasterGenerator {
    private static final long serialVersionUID = -6919031737595447726L;
    protected Classifier m_Classifier;
    protected String m_ForecastFields;
    protected String m_OverlayFields;
    protected LagMakerOptions m_LagMaker;
    protected int m_NumStepsConfidenceIntervals;
    protected double m_ConfidenceLevel;

    public String globalInfo() {
        return "Outputs a configured instance of a Weka Forecaster.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new LinearRegressionJ());
        this.m_OptionManager.add("forecast-fields", "forecastFields", (Object)"Value");
        this.m_OptionManager.add("overlay-fields", "overlayFields", (Object)"");
        this.m_OptionManager.add("lag-maker", "lagMaker", (Object)new LagMakerOptions());
        this.m_OptionManager.add("num-steps-confidence-intervals", "numStepsConfidenceIntervals", (Object)0, (Number)0, null);
        this.m_OptionManager.add("confidence-level", "confidenceLevel", (Object)0.95, (Number)0.0, (Number)1.0);
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The Weka classifier to train on the input data.";
    }

    public void setForecastFields(String value) {
        this.m_ForecastFields = value;
        this.reset();
    }

    public String getForecastFields() {
        return this.m_ForecastFields;
    }

    public String forecastFieldsTipText() {
        return "The fields to forecast (comma-separated list).";
    }

    public void setOverlayFields(String value) {
        this.m_OverlayFields = value;
        this.reset();
    }

    public String getOverlayFields() {
        return this.m_OverlayFields;
    }

    public String overlayFieldsTipText() {
        return "The fields to overlay (comma-separated list).";
    }

    public void setNumStepsConfidenceIntervals(int value) {
        this.m_NumStepsConfidenceIntervals = value;
        this.reset();
    }

    public int getNumStepsConfidenceIntervals() {
        return this.m_NumStepsConfidenceIntervals;
    }

    public String numStepsConfidenceIntervalsTipText() {
        return "The number of steps to generate confidence intervals for.";
    }

    public void setConfidenceLevel(double value) {
        if (value > 0.0 && value < 1.0) {
            this.m_ConfidenceLevel = value;
            this.reset();
        } else {
            this.getLogger().severe("Confidence level must satisfy: 0<x<1, provided: " + value);
        }
    }

    public double getConfidenceLevel() {
        return this.m_ConfidenceLevel;
    }

    public String confidenceLevelTipText() {
        return "The confidence level to use (0-1).";
    }

    public void setLagMaker(LagMakerOptions value) {
        this.m_LagMaker = value;
        this.reset();
    }

    public LagMakerOptions getLagMaker() {
        return this.m_LagMaker;
    }

    public String lagMakerTipText() {
        return "The lag maker options.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)Shortening.shortenEnd((String)OptionUtils.getShortCommandLine((Object)this.m_Classifier), (int)40));
    }

    @Override
    public AbstractForecaster generate() throws Exception {
        WekaForecaster result = new WekaForecaster();
        result.setBaseForecaster((Classifier)ObjectCopyHelper.copyObject((Object)this.m_Classifier));
        result.setFieldsToForecast(this.m_ForecastFields);
        if (this.m_OverlayFields.length() > 0) {
            result.setOverlayFields(this.m_OverlayFields);
        }
        result.setCalculateConfIntervalsForForecasts(this.m_NumStepsConfidenceIntervals);
        result.setConfidenceLevel(this.m_ConfidenceLevel);
        result.getTSLagMaker().setMinLag(this.m_LagMaker.getMinLag());
        result.getTSLagMaker().setMaxLag(this.m_LagMaker.getMaxLag());
        result.getTSLagMaker().setLagRange(this.m_LagMaker.getLagFineTune());
        result.getTSLagMaker().setAverageConsecutiveLongLags(this.m_LagMaker.getAverageConsecutiveLongLags());
        result.getTSLagMaker().setAverageLagsAfter(this.m_LagMaker.getAverageLagsAfter());
        result.getTSLagMaker().setNumConsecutiveLongLagsToAverage(this.m_LagMaker.getNumConsecutiveLongLagsToAverage());
        result.getTSLagMaker().setAdjustForTrends(this.m_LagMaker.getAdjustForTrends());
        result.getTSLagMaker().setAdjustForVariance(this.m_LagMaker.getAdjustForVariance());
        result.getTSLagMaker().setTimeStampField(this.m_LagMaker.getTimeStampField());
        result.getTSLagMaker().setAddAMIndicator(this.m_LagMaker.getAddAMIndicator());
        result.getTSLagMaker().setAddDayOfWeek(this.m_LagMaker.getAddDayOfWeek());
        result.getTSLagMaker().setAddDayOfMonth(this.m_LagMaker.getAddDayOfMonth());
        result.getTSLagMaker().setAddNumDaysInMonth(this.m_LagMaker.getAddNumDaysInMonth());
        result.getTSLagMaker().setAddWeekendIndicator(this.m_LagMaker.getAddWeekendIndicator());
        result.getTSLagMaker().setAddMonthOfYear(this.m_LagMaker.getAddMonthOfYear());
        result.getTSLagMaker().setAddQuarterOfYear(this.m_LagMaker.getAddQuarterOfYear());
        result.getTSLagMaker().setSkipEntries(this.m_LagMaker.getSkipEntries());
        return result;
    }
}

