/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.transformer.AbstractArrayProvider;
import gnu.trove.list.array.TIntArrayList;
import java.util.Date;
import java.util.List;

public class SpreadSheetRowToTimeseries
extends AbstractArrayProvider {
    private static final long serialVersionUID = -4857598976178462111L;
    protected SpreadSheetColumnIndex m_ColumnID;
    protected SpreadSheetColumnRange m_DataRange;
    protected BaseRegExp m_RegExpTimestamp;
    protected BaseRegExp m_RegExpValue;

    public String globalInfo() {
        return "Turns a spreadsheet row into a timeseries.\nColumns for timestamps and values are extracted using the regular expressions, the timestamp columns are optional.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-id", "columnID", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("data-range", "dataRange", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("regexp-timestamp", "regExpTimestamp", (Object)new BaseRegExp("Timestamp-.*"));
        this.m_OptionManager.add("regexp-value", "regExpValue", (Object)new BaseRegExp("Value-.*"));
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"columnID", (Object)this.m_ColumnID, (String)"ID: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataRange", (Object)this.m_DataRange, (String)", Range: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExpTimestamp", (BaseRegExp)this.m_RegExpTimestamp, (String)", Timestamp: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExpValue", (BaseRegExp)this.m_RegExpValue, (String)", Value: ");
        return result;
    }

    public void setColumnID(SpreadSheetColumnIndex value) {
        this.m_ColumnID = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnID() {
        return this.m_ColumnID;
    }

    public String columnIDTipText() {
        return "The (optional) column storing the ID for a timeseries.";
    }

    public void setDataRange(SpreadSheetColumnRange value) {
        this.m_DataRange = value;
        this.reset();
    }

    public SpreadSheetColumnRange getDataRange() {
        return this.m_DataRange;
    }

    public String dataRangeTipText() {
        return "The range of columns to use for generating the timeseries.";
    }

    public void setRegExpTimestamp(BaseRegExp value) {
        this.m_RegExpTimestamp = value;
        this.reset();
    }

    public BaseRegExp getRegExpTimestamp() {
        return this.m_RegExpTimestamp;
    }

    public String regExpTimestampTipText() {
        return "The regular expression for matching the columns that contain the timestamps for the data points.";
    }

    public void setRegExpValue(BaseRegExp value) {
        this.m_RegExpValue = value;
        this.reset();
    }

    public BaseRegExp getRegExpValue() {
        return this.m_RegExpValue;
    }

    public String regExpValueTipText() {
        return "The regular expression for matching the columns that contain the values of the data points.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected Class getItemClass() {
        return Timeseries.class;
    }

    public String outputArrayTipText() {
        return "If enabled, outputs an array of Timeseries objects rather than one-by-one.";
    }

    protected String doExecute() {
        int i;
        String result = null;
        this.m_Queue.clear();
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_DataRange.setData((Object)sheet);
        this.m_ColumnID.setData((Object)sheet);
        int[] colData = this.m_DataRange.getIntIndices();
        int colID = this.m_ColumnID.getIntIndex();
        TIntArrayList colTimestamps = new TIntArrayList();
        TIntArrayList colValues = new TIntArrayList();
        List names = sheet.getColumnNames();
        for (i = 0; i < colData.length; ++i) {
            if (this.m_RegExpValue.isMatch((String)names.get(colData[i]))) {
                colValues.add(colData[i]);
                continue;
            }
            if (!this.m_RegExpTimestamp.isMatch((String)names.get(colData[i]))) continue;
            colTimestamps.add(colData[i]);
        }
        if (colTimestamps.size() > 0 && colTimestamps.size() != colValues.size()) {
            this.getLogger().warning("Number of columns with timestamps differs from number of value columns, therefore ignoring timestamps: " + colTimestamps.size() + " != " + colValues.size());
            colTimestamps.clear();
        }
        for (Row row : sheet.rows()) {
            Double value;
            Cell cell;
            Timeseries series = new Timeseries();
            if (colID != -1 && (cell = row.getCell(colID)) != null && !cell.isMissing()) {
                series.setID(row.getCell(colID).getContent());
            }
            if (colTimestamps.size() > 0) {
                for (i = 0; i < colTimestamps.size(); ++i) {
                    cell = row.getCell(colTimestamps.get(i));
                    if (cell == null || cell.isMissing()) continue;
                    Date timestamp = cell.toAnyDateType();
                    cell = row.getCell(colValues.get(i));
                    if (cell == null || cell.isMissing() || (value = cell.toDouble()) == null) continue;
                    series.add((DataPoint)new TimeseriesPoint(timestamp, value));
                }
            } else {
                for (i = 0; i < colValues.size(); ++i) {
                    cell = row.getCell(colValues.get(i));
                    if (cell == null || cell.isMissing() || (value = cell.toDouble()) == null) continue;
                    series.add((DataPoint)new TimeseriesPoint(new Date(i * 1000), value));
                }
            }
            this.m_Queue.add(series);
        }
        return result;
    }
}

