/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.Date;
import java.util.HashSet;

public class SpreadSheetToTimeseries
extends AbstractArrayProvider {
    private static final long serialVersionUID = -4857598976178462111L;
    protected SpreadSheetColumnIndex m_ColumnID;
    protected SpreadSheetColumnIndex m_ColumnTimestamp;
    protected SpreadSheetColumnIndex m_ColumnValue;

    public String globalInfo() {
        return "Extracts one or more timeseries from a spreadsheet.\nIt uses one column ('ID') to identify all the rows that belong to a single timeseries. The 'Timestamp' and 'Value' columns make up data points of a timeseries.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-id", "columnID", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("column-timestamp", "columnTimestamp", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("column-value", "columnValue", (Object)new SpreadSheetColumnIndex("3"));
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"columnID", (Object)this.m_ColumnID, (String)"ID: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnTimestamp", (Object)this.m_ColumnTimestamp, (String)", Timestamp: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnValue", (Object)this.m_ColumnValue, (String)", Value: ");
        return result;
    }

    public void setColumnID(SpreadSheetColumnIndex value) {
        this.m_ColumnID = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnID() {
        return this.m_ColumnID;
    }

    public String columnIDTipText() {
        return "The column to use for grouping the timeseries data points; if left empty all rows are added to the same timeseries.";
    }

    public void setColumnTimestamp(SpreadSheetColumnIndex value) {
        this.m_ColumnTimestamp = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnTimestamp() {
        return this.m_ColumnTimestamp;
    }

    public String columnTimestampTipText() {
        return "The column that contains the timestamp for the data points.";
    }

    public void setColumnValue(SpreadSheetColumnIndex value) {
        this.m_ColumnValue = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnValue() {
        return this.m_ColumnValue;
    }

    public String columnValueTipText() {
        return "The column that contains the value of the data points.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected Class getItemClass() {
        return Timeseries.class;
    }

    public String outputArrayTipText() {
        return "If enabled, outputs an array of Timeseries objects rather than one-by-one.";
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_ColumnID.setSpreadSheet(sheet);
        int colID = this.m_ColumnID.getIntIndex();
        int colTimestamp = -1;
        if (result == null) {
            this.m_ColumnTimestamp.setSpreadSheet(sheet);
            colTimestamp = this.m_ColumnTimestamp.getIntIndex();
            if (colTimestamp == -1) {
                result = "Failed to locate timestamp column: " + this.m_ColumnTimestamp.getIndex();
            }
            if (result == null) {
                HashSet types = new HashSet(sheet.getContentTypes(colTimestamp));
                types.remove(Cell.ContentType.TIME);
                types.remove(Cell.ContentType.DATE);
                types.remove(Cell.ContentType.DATETIME);
                types.remove(Cell.ContentType.DATETIMEMSEC);
                if (types.size() != 0) {
                    result = "Timestamp column ('" + this.m_ColumnTimestamp.getIndex() + "') contains other types than time/date/datetime: " + types;
                }
            }
        }
        int colValue = -1;
        if (result == null) {
            this.m_ColumnValue.setSpreadSheet(sheet);
            colValue = this.m_ColumnValue.getIntIndex();
            if (colValue == -1) {
                result = "Failed to locate value column: " + this.m_ColumnValue.getIndex();
            } else if (!sheet.isNumeric(colValue)) {
                result = "Value column is not numeric: " + this.m_ColumnValue.getIndex();
            }
        }
        if (result == null) {
            if (colID > -1) {
                sheet = sheet.getClone();
                sheet.sort(new RowComparator(new int[]{colID}));
            }
            String currID = null;
            Timeseries series = null;
            block6: for (Row row : sheet.rows()) {
                Date timestamp;
                if (colID == -1) {
                    if (series == null) {
                        series = new Timeseries();
                        if (sheet.getName() != null) {
                            series.setID(sheet.getName());
                        } else {
                            series.setID(new Date().toString());
                        }
                        this.m_Queue.add(series);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("New timeseries");
                        }
                    }
                } else if (!row.getContent(colID).equals(currID)) {
                    if (this.isLoggingEnabled() && series != null) {
                        this.getLogger().info("# data points: " + series.size());
                    }
                    currID = row.getContent(colID);
                    series = new Timeseries();
                    series.setID(currID);
                    this.m_Queue.add(series);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("New timeseries: " + currID);
                    }
                }
                if (!row.hasCell(colTimestamp) || row.getCell(colTimestamp).isMissing() || !row.hasCell(colValue) || row.getCell(colValue).isMissing()) continue;
                double value = row.getCell(colValue).toDouble();
                Cell cell = row.getCell(colTimestamp);
                switch (cell.getContentType()) {
                    case TIME: {
                        timestamp = new Date(cell.toTime().getTime());
                        break;
                    }
                    case DATE: {
                        timestamp = cell.toDate();
                        break;
                    }
                    case DATETIME: {
                        timestamp = new Date(cell.toDateTime().getTime());
                        break;
                    }
                    case DATETIMEMSEC: {
                        timestamp = new Date(cell.toDateTimeMsec().getTime());
                        break;
                    }
                    default: {
                        this.getLogger().severe("Unhandled cell type (for timestamp column): " + cell.getContentType());
                        continue block6;
                    }
                }
                series.add((DataPoint)new TimeseriesPoint(timestamp, value));
            }
        }
        return result;
    }
}

