/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.DateFormatString;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;

public class TimeseriesInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected ArrayList m_Queue;
    protected InfoType m_Type;
    protected DateFormatString m_Format;
    protected transient DateFormat m_Formatter;

    public String globalInfo() {
        return "Outputs information for a timeseries.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.ID);
        this.m_OptionManager.add("format", "format", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format for turning the timestamps into a string.";
    }

    public Class[] accepts() {
        return new Class[]{Timeseries.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case ID: 
            case MIN_TIMESTAMP: 
            case MAX_TIMESTAMP: {
                return new Class[]{String.class};
            }
            case NUM_POINTS: 
            case DB_ID: {
                return new Class[]{Integer.class};
            }
            case MIN_VALUE: 
            case MAX_VALUE: {
                return new Class[]{Double.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + this.m_Type);
    }

    protected String doExecute() {
        String result = null;
        Timeseries series = (Timeseries)((Object)this.m_InputToken.getPayload());
        if (this.m_Formatter == null) {
            this.m_Formatter = this.m_Format.toDateFormat();
        }
        this.m_Queue.clear();
        switch (this.m_Type) {
            case ID: {
                this.m_Queue.add(series.getID());
                break;
            }
            case DB_ID: {
                this.m_Queue.add(series.getDatabaseID());
                break;
            }
            case NUM_POINTS: {
                this.m_Queue.add(series.size());
                break;
            }
            case MIN_TIMESTAMP: {
                if (series.size() <= 0) break;
                this.m_Queue.add(this.m_Formatter.format(((TimeseriesPoint)((Object)series.toList().get(0))).getTimestamp()));
                break;
            }
            case MAX_TIMESTAMP: {
                if (series.size() <= 0) break;
                this.m_Queue.add(this.m_Formatter.format(((TimeseriesPoint)((Object)series.toList().get(series.size() - 1))).getTimestamp()));
                break;
            }
            case MIN_VALUE: {
                if (series.getMinValue() == null) break;
                this.m_Queue.add(new Double(series.getMinValue().getValue()));
                break;
            }
            case MAX_VALUE: {
                if (series.getMaxValue() == null) break;
                this.m_Queue.add(new Double(series.getMaxValue().getValue()));
                break;
            }
            default: {
                result = "Unhandled info type: " + this.m_Type;
            }
        }
        return result;
    }

    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }

    public static enum InfoType {
        ID,
        DB_ID,
        NUM_POINTS,
        MIN_TIMESTAMP,
        MAX_TIMESTAMP,
        MIN_VALUE,
        MAX_VALUE;

    }
}

