/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaForecastModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.source.WekaForecasterSetup;
import adams.flow.transformer.AbstractTransformer;
import java.io.PrintStream;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.core.TSLagUser;
import weka.core.Instances;

public class WekaTrainForecaster
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    protected CallableActorReference m_Forecaster;
    protected boolean m_StoreTransformed;

    public String globalInfo() {
        return "Trains a forecaster based on the incoming dataset and outputs the built model alongside the training header (in a model container).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("forecaster", "forecaster", (Object)new CallableActorReference(WekaForecasterSetup.class.getSimpleName()));
        this.m_OptionManager.add("store-transformed", "storeTransformed", (Object)false);
    }

    public void setForecaster(CallableActorReference value) {
        this.m_Forecaster = value;
        this.reset();
    }

    public CallableActorReference getForecaster() {
        return this.m_Forecaster;
    }

    public String forecasterTipText() {
        return "The Weka forecaster to train on the input data.";
    }

    public void setStoreTransformed(boolean value) {
        this.m_StoreTransformed = value;
        this.reset();
    }

    public boolean getStoreTransformed() {
        return this.m_StoreTransformed;
    }

    public String storeTransformedTipText() {
        return "If enabled, the transformed data is stored as well in the output container in case the forecaster implements " + TSLagUser.class.getName() + ".";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"forecaster", (Object)this.m_Forecaster);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"storeTransformed", (boolean)this.m_StoreTransformed, (String)"store transformed", (String)", ");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaForecastModelContainer.class};
    }

    protected AbstractForecaster getForecasterInstance() {
        MessageCollection errors = new MessageCollection();
        AbstractForecaster result = (AbstractForecaster)CallableActorHelper.getSetup(AbstractForecaster.class, (CallableActorReference)this.m_Forecaster, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            AbstractForecaster cls = this.getForecasterInstance();
            if (cls == null) {
                result = "Failed to obtain forecaster!";
                return result;
            }
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                Instances data = (Instances)this.m_InputToken.getPayload();
                cls.buildForecaster(data, new PrintStream[0]);
                WekaForecastModelContainer cont = new WekaForecastModelContainer(cls, new Instances(data, 0), data);
                if (this.m_StoreTransformed && cls instanceof TSLagUser) {
                    cont.setValue("Transformed", ((TSLagUser)cls).getTSLagMaker().getTransformedData(data));
                }
                this.m_OutputToken = new Token((Object)cont);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        return result;
    }
}

