/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.base.BaseDateTime;
import adams.flow.core.Actor;
import adams.gui.visualization.core.PaintletWithFixedXRange;
import adams.gui.visualization.timeseries.PaintletWithFixedYRange;

public class PaintletWithFixedXYRange
extends PaintletWithFixedYRange
implements PaintletWithFixedXRange {
    private static final long serialVersionUID = -7452372971179139015L;
    protected BaseDateTime m_MinX;
    protected BaseDateTime m_MaxX;
    protected Actor m_Actor;

    @Override
    public String globalInfo() {
        return "Meta-paintlet that uses a fixed X and Y ranges (for faster drawing) and a base-paintlet to draw the actual data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-x", "minX", (Object)new BaseDateTime("-INF"));
        this.m_OptionManager.add("max-x", "maxX", (Object)new BaseDateTime("+INF"));
    }

    public void setMinX(BaseDateTime value) {
        this.m_MinX = value;
        this.memberChanged(true);
    }

    public BaseDateTime getMinX() {
        return this.m_MinX;
    }

    public double getMinimumX() {
        return this.m_MinX.dateValue().getTime();
    }

    public String minXTipText() {
        return "The minimum value for the X range.";
    }

    public void setMaxX(BaseDateTime value) {
        this.m_MaxX = value;
        this.memberChanged(true);
    }

    public BaseDateTime getMaxX() {
        return this.m_MaxX;
    }

    public double getMaximumX() {
        return this.m_MaxX.dateValue().getTime();
    }

    public String maxXTipText() {
        return "The maximum value for the X range.";
    }
}

