/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.data.timeseries.Timeseries;
import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.container.DatabaseContainer;
import adams.gui.visualization.container.NamedContainer;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.timeseries.TimeseriesContainerManager;
import java.awt.Color;

public class TimeseriesContainer
extends AbstractContainer
implements VisibilityContainer,
NamedContainer,
ColorContainer,
DatabaseContainer {
    private static final long serialVersionUID = -2589474045543243525L;
    protected boolean m_Visible;
    protected Color m_Color;

    public TimeseriesContainer(TimeseriesContainerManager manager, Timeseries data) {
        super((AbstractContainerManager)manager, (Comparable)((Object)data));
    }

    protected void initialize() {
        super.initialize();
        this.m_Visible = true;
        this.m_Color = Color.WHITE;
    }

    public void setID(String value) {
        this.getData().setID(value);
    }

    public String getID() {
        return this.getData().getID();
    }

    public String getDisplayID() {
        return this.getID();
    }

    public void setData(Timeseries value) {
        this.setPayload((Comparable)((Object)value));
    }

    public Timeseries getData() {
        return (Timeseries)((Object)this.getPayload());
    }

    public void setVisible(boolean value) {
        this.m_Visible = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.VISIBILITY, this.getManager().indexOf((AbstractContainer)this)));
        }
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    public void setColor(Color value) {
        this.m_Color = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.UPDATE, this.getManager().indexOf((AbstractContainer)this)));
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public int getDatabaseID() {
        if (this.getData().hasReport()) {
            return this.getData().getDatabaseID();
        }
        return -1;
    }

    public void assign(AbstractContainer c) {
        super.assign(c);
        this.m_Updating = true;
        if (c instanceof TimeseriesContainer) {
            this.setID(((TimeseriesContainer)c).getID());
            this.setVisible(((TimeseriesContainer)c).isVisible());
            this.setColor(((TimeseriesContainer)c).getColor());
        }
        this.m_Updating = false;
    }

    public int hashCode() {
        return Long.toString(this.getData().getUniqueID()).hashCode();
    }

    public String toString() {
        return "DB ID: " + this.getData().getDatabaseID() + ", ID: " + this.getID() + ", Visible: " + this.isVisible() + ", Color: " + this.getColor();
    }
}

