/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.data.timeseries.Timeseries;
import adams.db.AbstractDatabaseConnection;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ColorContainerManager;
import adams.gui.visualization.container.DatabaseContainerManager;
import adams.gui.visualization.container.NamedContainerManagerWithUniqueNames;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.ColorProviderWithNameSupport;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.timeseries.TimeseriesContainer;
import adams.gui.visualization.timeseries.TimeseriesPanel;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TimeseriesContainerManager<C extends TimeseriesContainer>
extends AbstractContainerManager<C>
implements VisibilityContainerManager<C>,
ColorContainerManager<TimeseriesContainer>,
DatabaseContainerManager<C>,
NamedContainerManagerWithUniqueNames<C> {
    private static final long serialVersionUID = -6358705201552088288L;
    protected TimeseriesPanel m_Owner;
    protected boolean m_Reloadable;
    protected ColorProvider m_ColorProvider;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public TimeseriesContainerManager(TimeseriesPanel owner, AbstractDatabaseConnection dbcon) {
        this.m_Owner = owner;
        this.m_Reloadable = false;
        this.m_ColorProvider = new DefaultColorProvider();
        this.m_DatabaseConnection = dbcon;
    }

    public TimeseriesPanel getOwner() {
        return this.m_Owner;
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection = value;
    }

    public void setReloadable(boolean value) {
        this.m_Reloadable = value;
    }

    public boolean isReloadable() {
        return this.m_Reloadable;
    }

    public synchronized void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        for (int i = 0; i < this.count(); ++i) {
            ((TimeseriesContainer)this.get(i)).setColor(this.getColor((TimeseriesContainer)this.get(i)));
        }
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public Color getColor(TimeseriesContainer cont) {
        if (this.m_ColorProvider instanceof ColorProviderWithNameSupport) {
            return ((ColorProviderWithNameSupport)this.m_ColorProvider).next(cont.getID());
        }
        return this.m_ColorProvider.next();
    }

    public void clear() {
        super.clear();
        this.m_ColorProvider.resetColors();
    }

    public void postAdd(TimeseriesContainer c) {
        if (c.getColor() == Color.WHITE) {
            c.setColor(this.getColor(c));
        } else {
            this.m_ColorProvider.exclude(c.getColor());
        }
    }

    public C remove(int index) {
        if (!this.m_AllowRemoval) {
            return null;
        }
        this.m_ColorProvider.recycle(((TimeseriesContainer)this.get(index)).getColor());
        return (C)((Object)((TimeseriesContainer)super.remove(index)));
    }

    protected HashSet<String> getIDs() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.count(); ++i) {
            result.add(((TimeseriesContainer)this.get(i)).getID());
        }
        return result;
    }

    public synchronized String getUniqueName(HashSet<String> ids, String id) {
        Object result = id;
        while (ids.contains(result)) {
            result = (String)result + "'";
        }
        return result;
    }

    public TimeseriesContainer updateName(TimeseriesContainer c, TimeseriesContainer old) {
        HashSet<String> ids = this.getIDs();
        if (old != null) {
            ids.remove(old.getID());
        }
        c.setID(this.getUniqueName(ids, c.getID()));
        return c;
    }

    public C newContainer(Comparable o) {
        return (C)((Object)new TimeseriesContainer(this, (Timeseries)((Object)o)));
    }

    protected TimeseriesContainer preAdd(TimeseriesContainer c) {
        return this.updateName(c, (TimeseriesContainer)null);
    }

    protected TimeseriesContainer preSet(int index, TimeseriesContainer c) {
        return this.updateName(c, (TimeseriesContainer)this.get(index));
    }

    public boolean isVisible(int index) {
        return ((TimeseriesContainer)this.get(index)).isVisible();
    }

    public void setVisible(int index, boolean visible) {
        ((TimeseriesContainer)this.get(index)).setVisible(visible);
    }

    public C getVisible(int index) {
        TimeseriesContainer result = null;
        int count = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (this.isVisible(i)) {
                ++count;
            }
            if (count != index) continue;
            result = (TimeseriesContainer)this.get(i);
            break;
        }
        return (C)((Object)result);
    }

    public int countVisible() {
        int result = 0;
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            ++result;
        }
        return result;
    }

    public int indexOf(String id) {
        int result = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (!((TimeseriesContainer)this.get(i)).getID().equals(id)) continue;
            result = i;
            break;
        }
        return result;
    }

    public int[] getVisibleIndices() {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public List<C> getAllVisible() {
        ArrayList<TimeseriesContainer> result = new ArrayList<TimeseriesContainer>();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            TimeseriesContainer cont = (TimeseriesContainer)((TimeseriesContainer)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    protected boolean isMatch(C cont, String search, boolean regExp) {
        if (regExp) {
            return ((TimeseriesContainer)((Object)cont)).getID().matches(search);
        }
        return ((TimeseriesContainer)((Object)cont)).getID().toLowerCase().contains(search);
    }
}

