/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.io.output.AbstractTimeseriesWriter;
import adams.data.io.output.MetaFileWriter;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.data.statistics.InformativeStatistic;
import adams.data.timeseries.PeriodicityHelper;
import adams.data.timeseries.PeriodicityType;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.ColorHelper;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.event.PaintListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.DataContainerPanelWithContainerList;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.CoordinatesPaintlet;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PaintletWithFixedXRange;
import adams.gui.visualization.core.PaintletWithFixedYRange;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.report.ReportContainer;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.statistics.InformativeStatisticFactory;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import adams.gui.visualization.timeseries.PeriodicityColorProvider;
import adams.gui.visualization.timeseries.PeriodicityPaintlet;
import adams.gui.visualization.timeseries.SelectedTimestampPaintlet;
import adams.gui.visualization.timeseries.TimeseriesContainer;
import adams.gui.visualization.timeseries.TimeseriesContainerList;
import adams.gui.visualization.timeseries.TimeseriesContainerManager;
import adams.gui.visualization.timeseries.TimeseriesExportDialog;
import adams.gui.visualization.timeseries.TimeseriesPaintlet;
import adams.gui.visualization.timeseries.TimeseriesPointHitDetector;
import adams.gui.visualization.timeseries.TimeseriesZoomOverviewPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TimeseriesPanel<T extends Timeseries, M extends TimeseriesContainerManager<C>, C extends TimeseriesContainer>
extends DataContainerPanelWithContainerList<T, M, C>
implements PaintListener,
TipTextCustomizer,
AntiAliasingSupporter,
HitDetectorSupporter<TimeseriesPointHitDetector> {
    private static final long serialVersionUID = -9059718549932104312L;
    protected boolean m_AdjustToVisibleData;
    protected CoordinatesPaintlet m_CoordinatesPaintlet;
    protected AbstractTimeseriesPaintlet m_TimeseriesPaintlet;
    protected PeriodicityPaintlet m_PeriodicityPaintlet;
    protected SelectedTimestampPaintlet m_SelectedTimestampPaintlet;
    protected TimeseriesPointHitDetector m_TimeseriesPointHitDetector;
    protected int m_ToolTipMaxColumns;
    protected int m_ToolTipMaxRows;
    protected TimeseriesZoomOverviewPanel m_PanelZoomOverview;
    protected TimeseriesExportDialog m_ExportDialog;

    public TimeseriesPanel() {
    }

    public TimeseriesPanel(String title) {
        super(title);
    }

    protected void initialize() {
        super.initialize();
        this.m_AdjustToVisibleData = true;
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    protected M newContainerManager() {
        return (M)((Object)new TimeseriesContainerManager(this, this.getDatabaseConnection()));
    }

    public AbstractTimeseriesPaintlet getContainerPaintlet() {
        return this.m_TimeseriesPaintlet;
    }

    public TimeseriesPointHitDetector getHitDetector() {
        return this.m_TimeseriesPointHitDetector;
    }

    public PeriodicityPaintlet getPeriodicityPaintlet() {
        return this.m_PeriodicityPaintlet;
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.m_ToolTipMaxColumns = props.getInteger("Plot.ToolTip.MaxColumns", Integer.valueOf(80));
        this.m_ToolTipMaxRows = props.getInteger("Plot.ToolTip.MaxRows", Integer.valueOf(40));
        this.setAdjustToVisibleData(props.getBoolean("Plot.AdjustToVisibleData", Boolean.valueOf(false)));
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        panel.setPreferredSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        this.m_SidePanel.add((Component)panel, "South");
        this.m_TimeseriesPaintlet = new TimeseriesPaintlet();
        this.m_TimeseriesPaintlet.setStrokeThickness(props.getDouble("Plot.StrokeThickness", Double.valueOf(1.0)).floatValue());
        this.m_TimeseriesPaintlet.setPanel((PaintablePanel)this);
        if (this.m_TimeseriesPaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)this.m_TimeseriesPaintlet).setAntiAliasingEnabled(props.getBoolean("Plot.AntiAliasing", Boolean.valueOf(true)).booleanValue());
        }
        this.m_PeriodicityPaintlet = new PeriodicityPaintlet();
        this.m_PeriodicityPaintlet.setPanel((PaintablePanel)this);
        this.m_PeriodicityPaintlet.setPeriodicity(PeriodicityType.valueOf(props.getProperty("Plot.Periodicity", PeriodicityType.NONE.toString())));
        this.m_PeriodicityPaintlet.setColorProvider(AbstractColorProvider.forCommandLine((String)props.getProperty("Plot.PeriodicityColorProvider", OptionUtils.getCommandLine((Object)((Object)new PeriodicityColorProvider())))));
        this.getPlot().getAxis(Axis.BOTTOM).setNumberFormat(PeriodicityHelper.getFormat(this.m_PeriodicityPaintlet.getPeriodicity()));
        this.m_SelectedTimestampPaintlet = new SelectedTimestampPaintlet();
        this.m_SelectedTimestampPaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet = new CoordinatesPaintlet();
        this.m_CoordinatesPaintlet.setYInvisible(true);
        this.m_CoordinatesPaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet.setXColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.X, Color.DARK_GRAY));
        this.m_CoordinatesPaintlet.setYColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.Y, Color.DARK_GRAY));
        this.getPlot().setPopupMenuCustomizer((PopupMenuCustomizer)this);
        try {
            ((TimeseriesContainerManager)this.getContainerManager()).setColorProvider((ColorProvider)OptionUtils.forAnyCommandLine(ColorProvider.class, (String)props.getProperty("Plot.ColorProvider", DefaultColorProvider.class.getName())));
        }
        catch (Exception e) {
            System.err.println(((Object)((Object)this)).getClass().getName() + " - Failed to set the color provider:");
            ((TimeseriesContainerManager)this.getContainerManager()).setColorProvider((ColorProvider)new DefaultColorProvider());
        }
        this.m_TimeseriesPointHitDetector = new TimeseriesPointHitDetector(this);
        this.getPlot().setTipTextCustomizer((TipTextCustomizer)this);
        this.m_PanelZoomOverview = new TimeseriesZoomOverviewPanel();
        this.m_PlotWrapperPanel.add((Component)((Object)this.m_PanelZoomOverview), (Object)"South");
        this.m_PanelZoomOverview.setDataContainerPanel((DataContainerPanel)this);
    }

    protected TimeseriesContainerList createContainerList() {
        TimeseriesContainerList result = new TimeseriesContainerList();
        result.setManager(this.getContainerManager());
        result.setAllowSearch(this.getProperties().getBoolean("ContainerList.AllowSearch", Boolean.valueOf(false)));
        result.setPopupMenuSupplier((ContainerListPopupMenuSupplier)this);
        result.setDisplayDatabaseID(true);
        result.addTableModelListener(e -> {
            ContainerTable table = result.getTable();
            if (table.getRowCount() > 0 && table.getSelectedRowCount() == 0) {
                SwingUtilities.invokeLater(() -> table.getSelectionModel().addSelectionInterval(0, 0));
            }
        });
        return result;
    }

    public void setTimeseriesPaintlet(AbstractTimeseriesPaintlet paintlet) {
        this.removePaintlet((Paintlet)this.m_TimeseriesPaintlet);
        this.m_TimeseriesPaintlet = paintlet;
        this.m_TimeseriesPaintlet.setPanel((PaintablePanel)this);
        this.addPaintlet((Paintlet)this.m_TimeseriesPaintlet);
    }

    public AbstractTimeseriesPaintlet getTimeseriesPaintlet() {
        return this.m_TimeseriesPaintlet;
    }

    public SelectedTimestampPaintlet getSelectedTimestampPaintlet() {
        return this.m_SelectedTimestampPaintlet;
    }

    public void setAdjustToVisibleData(boolean value) {
        this.m_AdjustToVisibleData = value;
        this.update();
    }

    public boolean getAdjustToVisibleData() {
        return this.m_AdjustToVisibleData;
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelZoomOverview.setVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelZoomOverview.isVisible();
    }

    public TimeseriesZoomOverviewPanel getZoomOverviewPanel() {
        return this.m_PanelZoomOverview;
    }

    protected boolean canPaint(Graphics g) {
        return this.getPlot() != null && this.m_Manager != null;
    }

    public void prepareUpdate() {
        boolean determineYRange = !(this.m_TimeseriesPaintlet instanceof PaintletWithFixedYRange);
        boolean determineXRange = !(this.m_TimeseriesPaintlet instanceof PaintletWithFixedXRange);
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        if (!determineYRange) {
            minY = ((PaintletWithFixedYRange)this.m_TimeseriesPaintlet).getMinimumY();
            maxY = ((PaintletWithFixedYRange)this.m_TimeseriesPaintlet).getMaximumY();
        }
        if (!determineXRange) {
            minX = ((PaintletWithFixedXRange)this.m_TimeseriesPaintlet).getMinimumX();
            maxX = ((PaintletWithFixedXRange)this.m_TimeseriesPaintlet).getMaximumX();
        }
        for (int i = 0; i < ((TimeseriesContainerManager)this.getContainerManager()).count(); ++i) {
            List points;
            if (this.m_AdjustToVisibleData && !((TimeseriesContainerManager)this.getContainerManager()).isVisible(i) || (points = ((TimeseriesContainer)((TimeseriesContainerManager)this.getContainerManager()).get(i)).getData().toList()).size() == 0) continue;
            if (determineXRange) {
                minX = Math.min(minX, (double)((TimeseriesPoint)((Object)points.get(0))).getTimestamp().getTime());
                maxX = Math.max(maxX, (double)((TimeseriesPoint)((Object)points.get(points.size() - 1))).getTimestamp().getTime());
            }
            if (!determineYRange) continue;
            maxY = Math.max(maxY, ((TimeseriesContainer)((TimeseriesContainerManager)this.getContainerManager()).get(i)).getData().getMaxValue().getValue());
            minY = Math.min(minY, ((TimeseriesContainer)((TimeseriesContainerManager)this.getContainerManager()).get(i)).getData().getMinValue().getValue());
        }
        if (minX == maxX) {
            minX -= 1.0;
            maxX += 1.0;
        }
        this.getPlot().getAxis(Axis.LEFT).setMinimum(minY);
        this.getPlot().getAxis(Axis.LEFT).setMaximum(maxY);
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(minX);
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(maxX);
    }

    public void showStatistics(List<InformativeStatistic> stats) {
        InformativeStatisticFactory.Dialog dialog = this.getParentDialog() != null ? InformativeStatisticFactory.getDialog((Dialog)this.getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : InformativeStatisticFactory.getDialog((Frame)this.getParentFrame(), (boolean)false);
        dialog.setStatistics(stats);
        dialog.setVisible(true);
    }

    public void showRawData(C cont) {
        SpreadSheetDialog dialog = this.getParentDialog() != null ? new SpreadSheetDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(this.getParentFrame(), false);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Timeseries");
        dialog.setSize(GUIHelper.getInteger((String)"DefaultSmallDialog.Width", (Integer)600).intValue(), GUIHelper.getInteger((String)"DefaultSmallDialog.Width", (Integer)600).intValue());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setSpreadSheet(((TimeseriesContainer)((Object)cont)).getData().toSpreadSheet());
        dialog.setNumDecimals(this.getProperties().getInteger("SpreadSheetPanel.NumDecimals", Integer.valueOf(3)).intValue());
        dialog.setVisible(true);
    }

    public void showReports(List<C> data) {
        ReportFactory.Dialog dialog = this.getParentDialog() != null ? ReportFactory.getDialog((Dialog)this.getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : ReportFactory.getDialog((Frame)this.getParentFrame(), (boolean)false);
        ArrayList<ReportContainer> conts = new ArrayList<ReportContainer>();
        for (TimeseriesContainer c : data) {
            ReportContainer rc = c.getData().hasReport() ? new ReportContainer(null, (ReportHandler)c.getData()) : new ReportContainer(null, new Report());
            conts.add(rc);
        }
        dialog.setData(conts);
        dialog.setReportContainerListWidth((int)this.getSidePanel().getPreferredSize().getWidth());
        dialog.setVisible(true);
    }

    public int[] getSelectedIndices() {
        return this.m_ContainerList.getTable().getSelectedRows();
    }

    public Timeseries[] getSelectedSeries() {
        ArrayList<Timeseries> result = new ArrayList<Timeseries>();
        for (int index : this.getSelectedIndices()) {
            result.add(((TimeseriesContainer)((TimeseriesContainerManager)this.getContainerManager()).get(index)).getData());
        }
        return result.toArray(new Timeseries[result.size()]);
    }

    public AbstractScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getSingleton((AbstractDatabaseConnection)this.getDatabaseConnection());
    }

    public void setAntiAliasingEnabled(boolean value) {
        if (this.m_TimeseriesPaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)this.m_TimeseriesPaintlet).setAntiAliasingEnabled(value);
        }
        if (this.m_PanelZoomOverview.getContainerPaintlet() instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)this.m_PanelZoomOverview.getContainerPaintlet()).setAntiAliasingEnabled(value);
        }
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_TimeseriesPaintlet instanceof AntiAliasingSupporter && ((AntiAliasingSupporter)this.m_TimeseriesPaintlet).isAntiAliasingEnabled();
    }

    protected void postUpdate() {
        super.postUpdate();
        if (this.m_PanelZoomOverview != null) {
            this.m_PanelZoomOverview.update();
        }
    }

    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        Object result = tiptext;
        MouseEvent event = new MouseEvent((Component)this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        String hit = (String)this.m_TimeseriesPointHitDetector.detect(event);
        if (hit != null) {
            result = (String)result + hit;
        }
        result = GUIHelper.processTipText((String)result, (int)this.m_ToolTipMaxColumns, (int)this.m_ToolTipMaxRows);
        return result;
    }

    public Paintlet getDataPaintlet() {
        return this.m_TimeseriesPaintlet;
    }

    public void setDataPaintlet(Paintlet value) {
        this.removePaintlet((Paintlet)this.m_TimeseriesPaintlet);
        this.m_TimeseriesPaintlet = (AbstractTimeseriesPaintlet)value;
        this.m_TimeseriesPaintlet.setPanel((PaintablePanel)this);
        this.addPaintlet((Paintlet)this.m_TimeseriesPaintlet);
    }

    public void saveVisibleSeries() {
        block5: {
            String[] ext;
            AbstractTimeseriesWriter writer;
            block4: {
                if (this.m_ExportDialog == null) {
                    this.m_ExportDialog = this.getParentDialog() != null ? new TimeseriesExportDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new TimeseriesExportDialog(this.getParentFrame(), true);
                }
                this.m_ExportDialog.setLocationRelativeTo((Component)((Object)this));
                this.m_ExportDialog.setVisible(true);
                if (this.m_ExportDialog.getOption() != 0) {
                    return;
                }
                writer = (AbstractTimeseriesWriter)((Object)this.m_ExportDialog.getExport());
                ext = writer instanceof MetaFileWriter ? ((MetaFileWriter)writer).getActualFormatExtensions() : writer.getFormatExtensions();
                if (!writer.canWriteMultiple() || !this.m_ExportDialog.getCombine()) break block4;
                Object filename = ((TimeseriesContainerManager)this.getContainerManager()).getVisible(0).getDisplayID() + "_and_" + (((TimeseriesContainerManager)this.getContainerManager()).countVisible() - 1) + "_more";
                filename = FileUtils.createFilename((String)filename, (String)"");
                filename = this.m_ExportDialog.getDirectory().getAbsolutePath() + File.separator + (String)filename + "." + ext[0];
                writer.setOutput(new PlaceholderFile((String)filename));
                ArrayList<Timeseries> data = new ArrayList<Timeseries>();
                for (TimeseriesContainer c : this.getTableModelContainers(true)) {
                    data.add(c.getData());
                }
                if (writer.write(data)) break block5;
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write timeseries data to '" + (String)filename + "'!"));
                break block5;
            }
            String prefix = this.m_ExportDialog.getDirectory().getAbsolutePath();
            for (TimeseriesContainer c : this.getTableModelContainers(true)) {
                String filename = prefix + File.separator + FileUtils.createFilename((String)c.getDisplayID(), (String)"") + "." + ext[0];
                writer.setOutput(new PlaceholderFile(filename));
                if (writer.write((DataContainer)c.getData())) continue;
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write timeseries #" + c + " to '" + filename + "'!"));
                break;
            }
        }
    }

    public boolean supportsStoreColorInReport() {
        return true;
    }

    public void storeColorInReport(int[] indices, String name) {
        Field field = new Field(name, DataType.STRING);
        for (int index : indices) {
            TimeseriesContainer cont = (TimeseriesContainer)((TimeseriesContainerManager)this.getContainerManager()).get(index);
            cont.getData().getReport().addField((AbstractField)field);
            cont.getData().getReport().setValue((AbstractField)field, (Object)ColorHelper.toHex((Color)cont.getColor()));
        }
    }

    public boolean supportsStoreValueInReport() {
        return true;
    }

    public void storeValueInReport(int[] indices, AbstractField field, Object value) {
        ((TimeseriesContainerManager)this.getContainerManager()).startUpdate();
        for (int index : indices) {
            TimeseriesContainer cont = (TimeseriesContainer)((TimeseriesContainerManager)this.getContainerManager()).get(index);
            cont.getData().getReport().addField(field);
            cont.getData().getReport().setValue(field, value);
        }
        ((TimeseriesContainerManager)this.getContainerManager()).finishUpdate();
    }

    public void cleanUp() {
        this.m_ContainerList.cleanUp();
        if (this.m_ExportDialog != null) {
            this.m_ExportDialog.dispose();
            this.m_ExportDialog = null;
        }
        super.cleanUp();
    }
}

