/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.gui;

import java.util.ArrayList;
import java.util.Hashtable;
import weka.classifiers.functions.LinearRegressionJ;
import weka.classifiers.timeseries.gui.ForecastingPanel;
import weka.classifiers.timeseries.gui.explorer.ExplorerTSPanelPublic;
import weka.gui.explorer.AbstractExplorerPanelHandler;
import weka.gui.explorer.Explorer;

public class ExplorerTSPanelHandler
extends AbstractExplorerPanelHandler {
    private static final long serialVersionUID = 6604498681201464567L;
    public static final String KEY_BASIC_COMPUTECONF = "basic: compute confidence";
    public static final String KEY_BASIC_CONFLEVEL = "basic: confidence level";
    public static final String KEY_BASIC_NUMTIMEUNITS = "basic: num time units";
    public static final String KEY_BASIC_SKIPLIST = "basic: skip list";
    public static final String KEY_BASIC_PERFORMEVAL = "basic: perform evaluation";
    public static final String KEY_ADV_BASELEARNER = "adv: base learner";
    public static final String KEY_ADV_LAGADJUST = "adv: lag adjust";
    public static final String KEY_ADV_CUSTOMLAG = "adv: custom lag";
    public static final String KEY_ADV_MINLAG = "adv: min lag";
    public static final String KEY_ADV_MAXLAG = "adv: max lag";
    public static final String KEY_ADV_FINETUNELAG = "adv: fine tune lag";
    public static final String KEY_ADV_AVGLONGLAGS = "adv: average long lags";
    public static final String KEY_ADV_AVGLAGSLONGERTHAN = "adv: average lags longer than";
    public static final String KEY_ADV_NUMLAGSTOAVG = "adv: num lags to average";
    public static final String KEY_ADV_OVERLAYDATA = "adv: use overlay data";
    public static final String KEY_ADV_EVALMETRICS = "adv: evaluation metrics";
    public static final String KEY_ADV_EVALONTRAIN = "adv: evaluation on train";
    public static final String KEY_ADV_EVALONHOLDOUT = "adv: evaluation on hold out";
    public static final String KEY_ADV_EVALHOLDOUTSIZE = "adv: evaluation hold out size";
    public static final String KEY_ADV_OUTPUTPREDS = "adv: output predictions";
    public static final String KEY_ADV_OUTPUTSTEP = "adv: output step";
    public static final String KEY_ADV_OUTPUTFUTURE = "adv: output future predictions";
    public static final String KEY_ADV_GRAPHPREDS = "adv: graph predictions";
    public static final String KEY_ADV_USEGRAPHTARGET = "adv: use graph target";
    public static final String KEY_ADV_GRAPHSTEP = "adv: graph step";
    public static final String KEY_ADV_GRAPHFUTURE = "adv: graph future predictions";

    public boolean handles(Explorer.ExplorerPanel panel) {
        return panel instanceof ExplorerTSPanelPublic;
    }

    public Object serialize(Explorer.ExplorerPanel panel) {
        ForecastingPanel pnl = ((ExplorerTSPanelPublic)panel).getForecastingPanel();
        ArrayList<Object> result = new ArrayList<Object>();
        Hashtable<String, Object> basic = new Hashtable<String, Object>();
        basic.put(KEY_BASIC_COMPUTECONF, pnl.m_simpleConfigPanel.m_computeConfidence.isSelected());
        basic.put(KEY_BASIC_CONFLEVEL, pnl.m_simpleConfigPanel.m_confidenceLevelSpinner.getValue());
        basic.put(KEY_BASIC_NUMTIMEUNITS, pnl.m_simpleConfigPanel.m_horizonSpinner.getValue());
        basic.put(KEY_BASIC_SKIPLIST, pnl.m_simpleConfigPanel.m_skipText.getText());
        basic.put(KEY_BASIC_PERFORMEVAL, pnl.m_simpleConfigPanel.m_performEvaluation.isSelected());
        result.add(basic);
        Hashtable<String, Object> advanced = new Hashtable<String, Object>();
        advanced.put(KEY_ADV_BASELEARNER, pnl.m_advancedConfigPanel.getBaseClassifier());
        advanced.put(KEY_ADV_LAGADJUST, pnl.m_advancedConfigPanel.m_adjustForVarianceCheckBox.isSelected());
        advanced.put(KEY_ADV_CUSTOMLAG, pnl.m_advancedConfigPanel.m_useCustomLags.isSelected());
        advanced.put(KEY_ADV_MINLAG, pnl.m_advancedConfigPanel.m_minLagSpinner.getValue());
        advanced.put(KEY_ADV_MAXLAG, pnl.m_advancedConfigPanel.m_maxLagSpinner.getValue());
        advanced.put(KEY_ADV_FINETUNELAG, pnl.m_advancedConfigPanel.m_fineTuneLagsField.getText());
        advanced.put(KEY_ADV_AVGLONGLAGS, pnl.m_advancedConfigPanel.m_averageLongLags.isSelected());
        advanced.put(KEY_ADV_AVGLAGSLONGERTHAN, pnl.m_advancedConfigPanel.m_averageLagsAfter.getValue());
        advanced.put(KEY_ADV_NUMLAGSTOAVG, pnl.m_advancedConfigPanel.m_numConsecutiveToAverage.getValue());
        advanced.put(KEY_ADV_EVALMETRICS, pnl.m_advancedConfigPanel.m_evaluationMetrics.getSelectedAttributes());
        advanced.put(KEY_ADV_EVALONTRAIN, pnl.m_advancedConfigPanel.m_trainingCheckBox.isSelected());
        advanced.put(KEY_ADV_EVALONHOLDOUT, pnl.m_advancedConfigPanel.m_holdoutCheckBox.isSelected());
        advanced.put(KEY_ADV_EVALHOLDOUTSIZE, pnl.m_advancedConfigPanel.m_holdoutSize.getText());
        advanced.put(KEY_ADV_OUTPUTPREDS, pnl.m_advancedConfigPanel.m_outputPredsCheckBox.isSelected());
        advanced.put(KEY_ADV_OUTPUTSTEP, pnl.m_advancedConfigPanel.m_outputStepSpinner.getValue());
        advanced.put(KEY_ADV_OUTPUTFUTURE, pnl.m_advancedConfigPanel.m_outputFutureCheckBox.isSelected());
        advanced.put(KEY_ADV_GRAPHPREDS, pnl.m_advancedConfigPanel.m_graphPredsAtStepCheckBox.isSelected());
        advanced.put(KEY_ADV_USEGRAPHTARGET, pnl.m_advancedConfigPanel.m_graphTargetForStepsCheckBox.isSelected());
        advanced.put(KEY_ADV_GRAPHSTEP, pnl.m_advancedConfigPanel.m_graphPredsAtStepSpinner.getValue());
        advanced.put(KEY_ADV_GRAPHFUTURE, pnl.m_advancedConfigPanel.m_graphFutureCheckBox.isSelected());
        result.add(advanced);
        result.add(this.serialize(pnl.m_history));
        return result;
    }

    public void deserialize(Explorer.ExplorerPanel panel, Object data) {
        ForecastingPanel pnl = ((ExplorerTSPanelPublic)panel).getForecastingPanel();
        ArrayList list = (ArrayList)data;
        Hashtable basic = (Hashtable)list.get(0);
        this.restoreSelectedState(basic, KEY_BASIC_COMPUTECONF, false, pnl.m_simpleConfigPanel.m_computeConfidence);
        this.restoreSpinner(basic, KEY_BASIC_CONFLEVEL, 95, pnl.m_simpleConfigPanel.m_confidenceLevelSpinner);
        this.restoreSpinner(basic, KEY_BASIC_NUMTIMEUNITS, 1, pnl.m_simpleConfigPanel.m_horizonSpinner);
        this.restoreText(basic, KEY_BASIC_SKIPLIST, "", pnl.m_simpleConfigPanel.m_skipText);
        this.restoreSelectedState(basic, KEY_BASIC_PERFORMEVAL, false, pnl.m_simpleConfigPanel.m_performEvaluation);
        Hashtable advanced = (Hashtable)list.get(1);
        this.restoreGOE(advanced, KEY_ADV_BASELEARNER, new LinearRegressionJ(), pnl.m_advancedConfigPanel.m_baseLearnerEditor);
        this.restoreSelectedState(advanced, KEY_ADV_LAGADJUST, false, pnl.m_advancedConfigPanel.m_adjustForVarianceCheckBox);
        this.restoreSelectedState(advanced, KEY_ADV_CUSTOMLAG, false, pnl.m_advancedConfigPanel.m_useCustomLags);
        this.restoreSpinner(advanced, KEY_ADV_MINLAG, 1, pnl.m_advancedConfigPanel.m_minLagSpinner);
        this.restoreSpinner(advanced, KEY_ADV_MAXLAG, 12, pnl.m_advancedConfigPanel.m_maxLagSpinner);
        this.restoreText(advanced, KEY_ADV_FINETUNELAG, "", pnl.m_advancedConfigPanel.m_fineTuneLagsField);
        this.restoreSelectedState(advanced, KEY_ADV_AVGLONGLAGS, false, pnl.m_advancedConfigPanel.m_averageLongLags);
        this.restoreSpinner(advanced, KEY_ADV_AVGLAGSLONGERTHAN, 2, pnl.m_advancedConfigPanel.m_averageLagsAfter);
        this.restoreSpinner(advanced, KEY_ADV_NUMLAGSTOAVG, 2, pnl.m_advancedConfigPanel.m_numConsecutiveToAverage);
        this.restoreSelectedState(advanced, KEY_ADV_EVALONTRAIN, false, pnl.m_advancedConfigPanel.m_trainingCheckBox);
        this.restoreSelectedState(advanced, KEY_ADV_EVALONHOLDOUT, false, pnl.m_advancedConfigPanel.m_holdoutCheckBox);
        this.restoreText(advanced, KEY_ADV_EVALHOLDOUTSIZE, "0.3", pnl.m_advancedConfigPanel.m_holdoutSize);
        this.restoreSelectedState(advanced, KEY_ADV_OUTPUTPREDS, false, pnl.m_advancedConfigPanel.m_outputPredsCheckBox);
        this.restoreSpinner(advanced, KEY_ADV_OUTPUTSTEP, 1, pnl.m_advancedConfigPanel.m_outputStepSpinner);
        this.restoreSelectedState(advanced, KEY_ADV_OUTPUTFUTURE, true, pnl.m_advancedConfigPanel.m_outputFutureCheckBox);
        this.restoreSelectedState(advanced, KEY_ADV_GRAPHPREDS, false, pnl.m_advancedConfigPanel.m_graphPredsAtStepCheckBox);
        this.restoreSelectedState(advanced, KEY_ADV_EVALONHOLDOUT, false, pnl.m_advancedConfigPanel.m_holdoutCheckBox);
        this.restoreSelectedState(advanced, KEY_ADV_USEGRAPHTARGET, false, pnl.m_advancedConfigPanel.m_graphTargetForStepsCheckBox);
        this.restoreSpinner(advanced, KEY_ADV_GRAPHSTEP, 1, pnl.m_advancedConfigPanel.m_graphPredsAtStepSpinner);
        this.restoreSelectedState(advanced, KEY_ADV_GRAPHFUTURE, true, pnl.m_advancedConfigPanel.m_graphFutureCheckBox);
        pnl.m_advancedConfigPanel.updateEvalAndOutputEnabledStatus();
        this.deserialize(list.get(2), pnl.m_history);
    }
}

