/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.Console;
import adams.flow.source.TwitterQuery;
import adams.flow.transformer.TwitterConverter;
import adams.flow.transformer.TwitterFilter;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TwitterFilterTest
extends AbstractFlowTest {
    public TwitterFilterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        TwitterQuery tq = new TwitterQuery();
        tq.setQuery("work");
        tq.setMaxTweets(200);
        tq.setResultsPerPage(10);
        TwitterFilter tf = new TwitterFilter();
        tf.setExpression("text:\":)\" or text:\":(\"");
        TwitterConverter tc = new TwitterConverter();
        tc.setOutputType(TwitterConverter.OutputType.STRING);
        tc.setFields(new TwitterConverter.TwitterField[]{TwitterConverter.TwitterField.TEXT});
        Console con = new Console();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{tq, tf, tc, con});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(TwitterFilterTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TwitterFilterTest.runTest((Test)TwitterFilterTest.suite());
    }
}

