/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TwitterQueryTest.java
 * Copyright (C) 2010-2013 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.source;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.Console;
import adams.flow.standalone.TwitterConnection;
import adams.flow.transformer.TwitterConverter;
import adams.flow.transformer.TwitterConverter.OutputType;
import adams.flow.transformer.TwitterConverter.TwitterField;

/**
 * Tests the TwitterQuery actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 7119 $
 */
public class TwitterQueryTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public TwitterQueryTest(String name) {
    super(name);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  @Override
  public AbstractActor getActor() {
    TwitterConnection tc = new TwitterConnection();
    
    TwitterQuery tq = new TwitterQuery();
    tq.setQuery("superhero since:2010-07-01");
    tq.setMaxTweets(20);
    tq.setResultsPerPage(10);

    TwitterConverter tw = new TwitterConverter();
    tw.setOutputType(OutputType.STRING);
    tw.setFields(new TwitterField[]{TwitterField.TEXT});

    Console con = new Console();

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{tc, tq, tw, con});

    return flow;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(TwitterQueryTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
