/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.net.TwitterHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.parser.GrammarSupplier;
import adams.parser.TwitterFilter;
import java.util.HashMap;
import java.util.logging.Level;
import twitter4j.Status;

public class TwitterFilterExpression
extends AbstractBooleanCondition
implements GrammarSupplier {
    private static final long serialVersionUID = -9169161144858552052L;
    protected adams.core.base.TwitterFilterExpression m_Expression;

    public String globalInfo() {
        return "Evaluates to 'true' if the twitter expression evaluates to 'true'.\nThe following grammar is used for evaluating the expressions:\n\n" + this.getGrammar();
    }

    public String getGrammar() {
        return new adams.core.base.TwitterFilterExpression().getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", (Object)this.getDefaultExpression());
    }

    protected adams.core.base.TwitterFilterExpression getDefaultExpression() {
        return new adams.core.base.TwitterFilterExpression("");
    }

    public void setExpression(adams.core.base.TwitterFilterExpression value) {
        if (Variables.isPlaceholder((String)value.getValue())) {
            value = new adams.core.base.TwitterFilterExpression("(" + value.getValue() + ")");
        }
        this.m_Expression = value;
        this.reset();
    }

    public adams.core.base.TwitterFilterExpression getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The filter expression to evaluate.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"expression", (Object)((Object)this.m_Expression));
    }

    public Class[] accepts() {
        return new Class[]{Status.class};
    }

    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null && (this.m_Expression == null || this.m_Expression.getValue().length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    protected boolean doEvaluate(String exp, HashMap symbols) {
        boolean result;
        try {
            result = TwitterFilter.evaluate(exp, symbols);
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("exp: " + (Object)((Object)this.getExpression()) + "\n" + "  --> " + exp + "\n" + "  = " + result);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error evaluating boolean expression: " + exp, e);
            result = false;
        }
        return result;
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        String exp = owner.getVariables().expand(this.getExpression().getValue());
        HashMap symbols = new HashMap();
        if (token != null && token.getPayload() != null && token.getPayload() instanceof Status) {
            symbols = TwitterHelper.statusToSymbols((Status)token.getPayload(), true);
        }
        try {
            return this.doEvaluate(exp, symbols);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to evaluate '" + exp + "' with symbols: " + symbols, t);
        }
    }
}

