/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.core.net.TwitterHelper;
import adams.core.option.OptionHandler;
import adams.data.io.input.AbstractTweetReplay;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.twitter.SimulatedPlace;
import adams.data.twitter.SimulatedScopes;
import adams.data.twitter.SimulatedStatus;
import adams.data.twitter.SimulatedSymbolEntity;
import adams.data.twitter.SimulatedURLEntity;
import adams.data.twitter.SimulatedUser;
import adams.data.twitter.TwitterField;
import java.io.File;
import java.util.HashMap;
import twitter4j.GeoLocation;
import twitter4j.Status;
import twitter4j.SymbolEntity;
import twitter4j.URLEntity;

public abstract class AbstractCsvArchive
extends AbstractTweetReplay {
    private static final long serialVersionUID = -3432288686771377759L;
    protected PlaceholderFile m_Archive;
    protected CsvSpreadSheetReader m_Reader;
    protected SpreadSheet m_Chunk;
    protected HashMap<TwitterField, Integer> m_Columns;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("archive", "archive", (Object)new PlaceholderFile("."));
    }

    protected void initialize() {
        super.initialize();
        this.m_Reader = new CsvSpreadSheetReader();
        this.m_Reader.setChunkSize(1);
        this.m_Reader.setParseFormulas(false);
        this.m_Reader.setMissingValue(new BaseRegExp(""));
    }

    protected void reset() {
        super.reset();
        this.m_Chunk = null;
        this.m_Columns = null;
    }

    public void setArchive(PlaceholderFile value) {
        this.m_Archive = value;
        this.reset();
    }

    public PlaceholderFile getArchive() {
        return this.m_Archive;
    }

    public abstract String archiveTipText();

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"archive", (Object)this.m_Archive, (String)"archive: ");
    }

    protected abstract HashMap<TwitterField, Integer> configureColumns(SpreadSheet var1);

    @Override
    protected String doConfigure() {
        String result = null;
        this.m_Chunk = this.m_Reader.read((File)this.m_Archive);
        if (this.m_Chunk == null) {
            result = "Failed to read from archive?";
        }
        if (result == null) {
            this.m_Columns = this.configureColumns(this.m_Chunk);
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.m_Chunk != null || this.m_Reader.hasMoreChunks();
    }

    protected SpreadSheet preprocessChunk(SpreadSheet chunk) {
        return chunk;
    }

    protected Status convert(Row row) {
        SimulatedStatus result = new SimulatedStatus();
        result.setUser(new SimulatedUser());
        result.setPlace(new SimulatedPlace());
        if (this.m_Columns.containsKey((Object)TwitterField.RETWEETED_STATUS_ID) || this.m_Columns.containsKey((Object)TwitterField.RETWEETED_STATUS_USER_ID) || this.m_Columns.containsKey((Object)TwitterField.RETWEETED_STATUS_CREATED)) {
            result.setRetweetedStatus(new SimulatedStatus());
            ((SimulatedStatus)result.getRetweetedStatus()).setUser(new SimulatedUser());
        }
        if (this.m_Columns.containsKey((Object)TwitterField.QUOTED_STATUS_ID) || this.m_Columns.containsKey((Object)TwitterField.QUOTED_STATUS)) {
            result.setQuotedStatus(new SimulatedStatus());
        }
        block39: for (TwitterField field : this.m_Columns.keySet()) {
            int index;
            block48: {
                index = this.m_Columns.get((Object)field);
                try {
                    if (!row.hasCell(index)) continue;
                    if (row.getCell(index).isMissing()) {
                    }
                    break block48;
                }
                catch (Throwable t) {
                    if (!this.isLoggingEnabled()) continue;
                    Utils.handleException((LoggingSupporter)this, (String)("Failed to check missing status of cell at #" + index), (Throwable)t);
                }
                continue;
            }
            Cell cell = row.getCell(index);
            try {
                switch (field) {
                    case ID: {
                        result.setId(cell.toLong());
                        break;
                    }
                    case USER_ID: {
                        ((SimulatedUser)result.getUser()).setId(cell.toLong());
                        break;
                    }
                    case USER_NAME: {
                        ((SimulatedUser)result.getUser()).setName(cell.getContent());
                        break;
                    }
                    case SOURCE: {
                        result.setSource(cell.getContent());
                        break;
                    }
                    case TEXT: {
                        result.setText(cell.getContent());
                        result.setHashtagEntities(TwitterHelper.extractHashtags(cell.getContent()));
                        result.setUserMentionEntities(TwitterHelper.extractUserMentions(cell.getContent()));
                        break;
                    }
                    case CREATED: {
                        result.setCreatedAt(cell.toAnyDateType());
                        break;
                    }
                    case RETWEET: {
                        result.setRetweet(cell.toBoolean());
                        break;
                    }
                    case RETWEET_COUNT: {
                        result.setRetweetCount(cell.toLong().intValue());
                        break;
                    }
                    case RETWEET_BY_ME: {
                        result.setRetweetedByMe(cell.toBoolean());
                        break;
                    }
                    case RETWEETED_STATUS_ID: {
                        ((SimulatedStatus)result.getRetweetedStatus()).setId(cell.toLong());
                        break;
                    }
                    case RETWEETED_STATUS_USER_ID: {
                        ((SimulatedUser)((SimulatedStatus)result.getRetweetedStatus()).getUser()).setId(cell.toLong());
                        break;
                    }
                    case RETWEETED_STATUS_CREATED: {
                        ((SimulatedStatus)result.getRetweetedStatus()).setCreatedAt(cell.toAnyDateType());
                        break;
                    }
                    case EXPANDED_URLS: {
                        int i;
                        String[] parts = cell.getContent().split(",");
                        if (parts.length <= 0) continue block39;
                        URLEntity[] urlEntities = new URLEntity[parts.length];
                        for (i = 0; i < parts.length; ++i) {
                            urlEntities[i] = new SimulatedURLEntity(parts[i]);
                        }
                        result.setURLEntities(urlEntities);
                        break;
                    }
                    case IN_REPLY_TO_STATUS_ID: {
                        result.setInReplyToStatusId(cell.toLong());
                        break;
                    }
                    case IN_REPLY_TO_USER_ID: {
                        result.setInReplyToUserId(cell.toLong());
                        break;
                    }
                    case FAVORITED: {
                        if (cell.isDouble()) {
                            result.setFavorited(cell.toDouble() != 0.0);
                            break;
                        }
                        result.setFavorited(cell.toBoolean());
                        break;
                    }
                    case COUNTRY: {
                        ((SimulatedPlace)result.getPlace()).setCountry(cell.getContent());
                        break;
                    }
                    case COUNTRY_CODE: {
                        ((SimulatedPlace)result.getPlace()).setCountryCode(cell.getContent());
                        break;
                    }
                    case LANGUAGE_CODE: {
                        ((SimulatedUser)result.getUser()).setLang(cell.getContent());
                        break;
                    }
                    case PLACE: {
                        ((SimulatedPlace)result.getPlace()).setName(cell.getContent());
                        break;
                    }
                    case PLACE_TYPE: {
                        ((SimulatedPlace)result.getPlace()).setPlaceType(cell.getContent());
                        break;
                    }
                    case PLACE_URL: {
                        ((SimulatedPlace)result.getPlace()).setURL(cell.getContent());
                        break;
                    }
                    case STREET_ADDRESS: {
                        ((SimulatedPlace)result.getPlace()).setStreetAddress(cell.getContent());
                        break;
                    }
                    case POSSIBLY_SENSITIVE: {
                        if (cell.isDouble()) {
                            result.setPossiblySensitive(cell.toDouble() != 0.0);
                            break;
                        }
                        result.setPossiblySensitive(cell.toBoolean());
                        break;
                    }
                    case GEO_LATITUDE: 
                    case GEO_LONGITUDE: {
                        if (result.getGeoLocation() != null) continue block39;
                        result.setGeoLocation(new GeoLocation(row.getCell(this.m_Columns.get((Object)TwitterField.GEO_LATITUDE).intValue()).toDouble().doubleValue(), row.getCell(this.m_Columns.get((Object)TwitterField.GEO_LONGITUDE).intValue()).toDouble().doubleValue()));
                        break;
                    }
                    case SYMBOL_ENTITIES: {
                        int i;
                        String[] parts = cell.getContent().split(",");
                        SymbolEntity[] symEntities = new SymbolEntity[parts.length];
                        for (i = 0; i < parts.length; ++i) {
                            symEntities[i] = new SimulatedSymbolEntity();
                            ((SimulatedSymbolEntity)symEntities[i]).setText(parts[i]);
                        }
                        result.setSymbolEntities(symEntities);
                        break;
                    }
                    case IS_RETWEETED: {
                        result.setIsRetweeted(cell.toBoolean());
                        break;
                    }
                    case FAVORITE_COUNT: {
                        result.setFavoriteCount(cell.toLong().intValue());
                        break;
                    }
                    case STATUS_LANG: {
                        result.setLang(cell.getContent());
                        break;
                    }
                    case SCOPES: {
                        String[] parts = cell.getContent().split(",");
                        SimulatedScopes scopes = new SimulatedScopes();
                        scopes.setPlaceIds(parts);
                        result.setScopes(scopes);
                        break;
                    }
                    case WITHHELD_IN_COUNTRIES: {
                        result.setWithheldInCountries(cell.getContent().split(","));
                        break;
                    }
                    case QUOTED_STATUS_ID: {
                        result.setQuotedStatusId(cell.toLong());
                        ((SimulatedStatus)result.getQuotedStatus()).setId(cell.toLong());
                        break;
                    }
                    case QUOTED_STATUS: {
                        ((SimulatedStatus)result.getQuotedStatus()).setText(cell.getContent());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled twitter field: " + (Object)((Object)field));
                    }
                }
            }
            catch (Throwable t) {
                if (this.isLoggingEnabled()) {
                    Utils.handleException((LoggingSupporter)this, (String)("Failed to convert field '" + (Object)((Object)field) + "': " + cell + "\n" + row), (Throwable)t);
                }
                result = null;
            }
        }
        return result;
    }

    @Override
    public Status next() {
        Status result = null;
        if (this.m_Chunk.getRowCount() > 0) {
            result = this.convert((Row)this.m_Chunk.getRow(0));
        }
        this.m_Chunk = this.m_Reader.nextChunk();
        return result;
    }
}

