/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.io.input.AbstractTweetReplay;
import adams.data.io.input.FixedTweets;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import twitter4j.Status;

public class TweetReplay
extends AbstractSource {
    private static final long serialVersionUID = 2053838832805908215L;
    protected AbstractTweetReplay m_Replay;

    public String globalInfo() {
        return "Replays tweets using the specified replay class.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("replay", "replay", (Object)new FixedTweets());
    }

    public void setReplay(AbstractTweetReplay value) {
        this.m_Replay = value;
        this.reset();
    }

    public AbstractTweetReplay getReplay() {
        return this.m_Replay;
    }

    public String replayTipText() {
        return "The replay object for generating the tweets.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"replay", (Object)this.m_Replay, (String)"replay: ");
    }

    public Class[] generates() {
        return new Class[]{Status.class};
    }

    protected String doExecute() {
        return this.m_Replay.configure();
    }

    public boolean hasPendingOutput() {
        return this.m_Executed && this.m_Replay.hasNext();
    }

    public Token output() {
        Status status = null;
        if (this.m_Replay.hasNext()) {
            status = this.m_Replay.next();
        }
        if (status != null) {
            return new Token((Object)status);
        }
        return null;
    }
}

