/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;
import adams.data.twitter.TwitterField;
import adams.parser.GrammarSupplier;
import adams.parser.TwitterFilter;
import java.util.HashMap;

public class TwitterFilterExpression
extends BaseObject
implements GrammarSupplier {
    private static final long serialVersionUID = -5853830144343397434L;
    public static final String DEFAULT = "";
    protected static HashMap m_Symbols;

    public TwitterFilterExpression() {
        this(DEFAULT);
    }

    public TwitterFilterExpression(String s) {
        super(s);
    }

    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    protected synchronized HashMap getSymbols() {
        if (m_Symbols == null) {
            HashMap<Object, Object> symbols = new HashMap<Object, Object>();
            symbols.put((Object)TwitterField.LANGUAGE_CODE, "en");
            symbols.put((Object)TwitterField.COUNTRY, "new zealand");
            symbols.put((Object)TwitterField.COUNTRY_CODE, "nz");
            symbols.put((Object)TwitterField.PLACE, "hamilton");
            symbols.put((Object)TwitterField.SOURCE, "source");
            symbols.put((Object)TwitterField.TEXT, "a tweet");
            symbols.put((Object)TwitterField.USER_NAME, "user name");
            symbols.put((Object)TwitterField.USER_SCREENNAME, "screen name");
            symbols.put((Object)TwitterField.PLACE, "place");
            symbols.put("hashtags", new String[0]);
            symbols.put("usermentions", new String[0]);
            m_Symbols = symbols;
        }
        return m_Symbols;
    }

    protected Boolean parse(String s, boolean quiet) {
        try {
            return TwitterFilter.evaluate(s, this.getSymbols());
        }
        catch (Exception e) {
            if (!quiet) {
                System.err.println("Failed to parse: " + s);
                e.printStackTrace();
            }
            return null;
        }
    }

    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return true;
        }
        return this.parse(value, true) != null;
    }

    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        this.m_Internal = value;
    }

    public String getValue() {
        return (String)((Object)this.m_Internal);
    }

    public String stringValue() {
        return this.getValue();
    }

    public String getTipText() {
        return "A Twitter filter expression.";
    }

    public String getGrammar() {
        return new TwitterFilter().getGrammar();
    }
}

