/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractCsvArchive;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.twitter.SpreadSheetConverter;
import adams.data.twitter.TwitterField;
import java.util.HashMap;

public class SpreadSheetConverterArchive
extends AbstractCsvArchive {
    private static final long serialVersionUID = -3432288686771377759L;

    public String globalInfo() {
        return "Replays tweets stored in a CSV file (can be compressed with gzip) generated by the " + SpreadSheetConverter.class.getName() + " converter.\nExtracts hashtags ('#...') and usermentions ('@...') automatically.";
    }

    @Override
    public String archiveTipText() {
        return "The ADAMS CSV archive to load the tweets from.";
    }

    @Override
    protected HashMap<TwitterField, Integer> configureColumns(SpreadSheet chunk) {
        HashMap<TwitterField, Integer> result = new HashMap<TwitterField, Integer>();
        for (TwitterField field : TwitterField.values()) {
            int index = chunk.getHeaderRow().indexOfContent(field.toString());
            if (index <= -1) continue;
            result.put(field, index);
        }
        return result;
    }
}

