/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.twitterlistener;

import adams.flow.source.twitterlistener.AbstractListener;
import java.util.logging.Level;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.StreamListener;

public class SampleListener
extends AbstractListener
implements StatusListener {
    private static final long serialVersionUID = 5406360301457780558L;

    public String globalInfo() {
        return "Outputs status updates obtained from the 'garden hose'.";
    }

    @Override
    public void startExecution() {
        try {
            this.m_Twitter.addListener((StreamListener)this);
            this.m_Twitter.sample();
            this.m_Listening = true;
        }
        catch (Exception e) {
            this.m_Twitter.removeListener((StreamListener)this);
            this.getLogger().log(Level.SEVERE, "Failed to start listener!", (Throwable)e);
        }
    }

    @Override
    protected void removeListener() {
        this.m_Twitter.removeListener((StreamListener)this);
    }

    public void onStatus(Status status) {
        if (this.m_Listening && !this.m_Paused) {
            if (this.getMaxStatusUpdates() > 0 && this.m_Count >= this.getMaxStatusUpdates()) {
                this.stopExecution();
            } else {
                this.m_Next = status;
            }
        }
    }

    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
    }

    public void onTrackLimitationNotice(int i) {
    }

    public void onScrubGeo(long l, long l1) {
    }

    public void onStallWarning(StallWarning stallWarning) {
        this.getLogger().warning(stallWarning.toString());
    }

    public void onException(Exception e) {
        this.getLogger().log(Level.SEVERE, "Exception encountered while listening!", (Throwable)e);
    }
}

