/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.TwitterFilterExpression;
import adams.core.net.TwitterHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.parser.GrammarSupplier;
import java.util.HashMap;
import twitter4j.Status;

public class TwitterFilter
extends AbstractTransformer
implements GrammarSupplier {
    private static final long serialVersionUID = -449062766931736640L;
    protected TwitterFilterExpression m_Expression;

    public String globalInfo() {
        return "Filters Twitter objects (tweet/status) according to the provided filter expression. Only objects that match the filter expression are passed on.\n\nThe expressions use the following grammar:\n\n" + this.getGrammar();
    }

    public String getGrammar() {
        return new adams.parser.TwitterFilter().getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", (Object)new TwitterFilterExpression());
    }

    public void setExpression(TwitterFilterExpression value) {
        this.m_Expression = value;
        this.reset();
    }

    public TwitterFilterExpression getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The filter expression to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"expression", (Object)((Object)this.m_Expression));
    }

    public Class[] accepts() {
        return new Class[]{Status.class};
    }

    public Class[] generates() {
        return new Class[]{Status.class};
    }

    protected String doExecute() {
        String result = null;
        String exp = this.m_Expression.getValue();
        try {
            HashMap symbols = TwitterHelper.statusToSymbols((Status)this.m_InputToken.getPayload(), true);
            boolean match = adams.parser.TwitterFilter.evaluate(exp, symbols);
            if (match) {
                this.m_OutputToken = new Token(this.m_InputToken.getPayload());
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Error evaluating: " + exp, e);
        }
        return result;
    }
}

