/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.net.TwitterHelper;
import adams.env.Environment;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseTextField;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPasswordField;

public class TwitterSetupPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -7937644706618374284L;
    protected ParameterPanel m_PanelParameters;
    protected BaseTextField m_TextConsumerKey;
    protected JPasswordField m_TextConsumerSecret;
    protected BaseCheckBox m_CheckBoxShowConsumerSecret;
    protected BaseTextField m_TextAccessToken;
    protected JPasswordField m_TextAccessTokenSecret;
    protected BaseCheckBox m_CheckBoxShowAccessTokenSecret;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "Center");
        this.m_TextConsumerKey = new BaseTextField(20);
        this.m_TextConsumerKey.setText(TwitterHelper.getConsumerKey());
        this.m_PanelParameters.addParameter("Consumer _key", (Component)this.m_TextConsumerKey);
        this.m_TextConsumerSecret = new JPasswordField(20);
        this.m_TextConsumerSecret.setText(TwitterHelper.getConsumerSecret().getValue());
        this.m_TextConsumerSecret.setEchoChar('*');
        this.m_PanelParameters.addParameter("Consumer _secret", (Component)this.m_TextConsumerSecret);
        this.m_CheckBoxShowConsumerSecret = new BaseCheckBox();
        this.m_CheckBoxShowConsumerSecret.setSelected(false);
        this.m_CheckBoxShowConsumerSecret.addActionListener(e -> {
            if (this.m_CheckBoxShowConsumerSecret.isSelected()) {
                this.m_TextConsumerSecret.setEchoChar('\u0000');
            } else {
                this.m_TextConsumerSecret.setEchoChar('*');
            }
        });
        this.m_PanelParameters.addParameter("Show consumer secret", (Component)this.m_CheckBoxShowConsumerSecret);
        this.m_TextAccessToken = new BaseTextField(20);
        this.m_TextAccessToken.setText(TwitterHelper.getAccessToken());
        this.m_PanelParameters.addParameter("_Access token", (Component)this.m_TextAccessToken);
        this.m_TextAccessTokenSecret = new JPasswordField(20);
        this.m_TextAccessTokenSecret.setText(TwitterHelper.getAccessTokenSecret().getValue());
        this.m_TextAccessTokenSecret.setEchoChar('*');
        this.m_PanelParameters.addParameter("Access _token secret", (Component)this.m_TextAccessTokenSecret);
        this.m_CheckBoxShowAccessTokenSecret = new BaseCheckBox();
        this.m_CheckBoxShowAccessTokenSecret.setSelected(false);
        this.m_CheckBoxShowAccessTokenSecret.addActionListener(e -> {
            if (this.m_CheckBoxShowAccessTokenSecret.isSelected()) {
                this.m_TextAccessTokenSecret.setEchoChar('\u0000');
            } else {
                this.m_TextAccessTokenSecret.setEchoChar('*');
            }
        });
        this.m_PanelParameters.addParameter("Show access token secret", (Component)this.m_CheckBoxShowAccessTokenSecret);
    }

    protected Properties toProperties() {
        Properties result = new Properties();
        result.setProperty("ConsumerKey", this.m_TextConsumerKey.getText());
        result.setProperty("ConsumerSecret", this.m_TextConsumerSecret.getText());
        result.setProperty("AccessToken", this.m_TextAccessToken.getText());
        result.setProperty("AccessTokenSecret", this.m_TextAccessTokenSecret.getText());
        return result;
    }

    public String getTitle() {
        return "Twitter";
    }

    public boolean requiresWrapper() {
        return true;
    }

    public String activate() {
        boolean result = TwitterHelper.writeProperties(this.toProperties());
        if (result) {
            return null;
        }
        return "Failed to save twitter setup to Twitter.props!";
    }

    public boolean canReset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("twitter");
        return props != null && FileUtils.fileExists((String)props);
    }

    public String reset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("twitter");
        if (props != null && FileUtils.fileExists((String)props) && !FileUtils.delete((String)props)) {
            return "Failed to remove custom Twitter properties: " + props;
        }
        return null;
    }
}

