/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.base.BaseObject;
import adams.core.base.TwitterFilterExpression;
import adams.core.option.parsing.TwitterFilterExpressionParsing;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.GUIHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import adams.gui.help.HelpFrame;
import adams.parser.TwitterFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class TwitterFilterExpressionEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected JTextComponent m_TextValue;
    protected BaseButton m_ButtonHelp;

    public String toCustomStringRepresentation(Object obj) {
        return TwitterFilterExpressionParsing.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return TwitterFilterExpressionParsing.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + TwitterFilterExpressionParsing.toString(null, this.getValue()) + "\")";
        return result;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "[null]" : TwitterFilterExpressionParsing.toString(null, this.getValue());
        if (val.isEmpty()) {
            val = "[empty]";
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected JComponent createCustomEditor() {
        this.m_TextValue = new BaseTextArea(1, 20);
        ((BaseTextArea)this.m_TextValue).setLineWrap(true);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    TwitterFilterExpressionEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    TwitterFilterExpressionEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JPanel panelAll = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Value");
        label.setDisplayedMnemonic('V');
        label.setLabelFor(this.m_TextValue);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(label);
        panelAll.add((Component)panel, "West");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        panel.add((Component)new BaseScrollPane((Component)this.m_TextValue), "Center");
        panelAll.add((Component)panel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        this.m_ButtonHelp = new BaseButton((Icon)GUIHelper.getIcon((String)"help.gif"));
        this.m_ButtonHelp.setToolTipText("Display grammar");
        this.m_ButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpFrame.showHelp(TwitterFilter.class, (String)new TwitterFilter().getGrammar(), (boolean)false);
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "East");
        panel.add((Component)this.m_ButtonHelp);
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwitterFilterExpressionEditor.this.acceptInput();
            }
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonClose = new BaseButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwitterFilterExpressionEditor.this.discardInput();
            }
        });
        panelButtons.add((Component)buttonClose);
        return panelAll;
    }

    protected TwitterFilterExpression parse(String s) {
        TwitterFilterExpression result;
        try {
            result = new TwitterFilterExpression(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue((Object)this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setCaretPosition(0);
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_TextValue.grabFocus();
    }

    protected boolean isValid(String s) {
        return ((BaseObject)this.getValue()).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((BaseObject)this.getValue()).getValue());
    }

    public Object[] getSelectedObjects(Container parent) {
        MultiLineValueDialog dialog = GUIHelper.getParentDialog((Container)parent) != null ? new MultiLineValueDialog(GUIHelper.getParentDialog((Container)parent)) : new MultiLineValueDialog(GUIHelper.getParentFrame((Container)parent));
        dialog.setInfoText("Enter the filter expressions, one per line:");
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setVisible(true);
        List lines = dialog.getValues();
        TwitterFilterExpression[] result = new TwitterFilterExpression[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            result[i] = new TwitterFilterExpression((String)lines.get(i));
        }
        return result;
    }

    public boolean isInlineEditingAvailable() {
        return true;
    }

    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue((Object)new TwitterFilterExpression(value));
        }
    }

    public String getInlineValue() {
        return ((BaseObject)this.getValue()).getValue();
    }

    public boolean isInlineValueValid(String value) {
        return ((BaseObject)this.getValue()).isValid(value);
    }
}

