/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.twitterlistener;

import adams.core.QuickInfoHelper;
import adams.core.net.TwitterHelper;
import adams.core.option.OptionHandler;
import adams.flow.source.twitterlistener.AbstractListener;
import java.util.logging.Level;
import twitter4j.DirectMessage;
import twitter4j.FilterQuery;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StreamListener;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserStreamListener;

public class UserListener
extends AbstractListener
implements UserStreamListener {
    private static final long serialVersionUID = 5406360301457780558L;
    protected String m_User;

    public String globalInfo() {
        return "Outputs status updates obtained from the 'garden hose'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("user", "user", (Object)"");
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)(this.m_User.isEmpty() ? "not set" : this.m_User), (String)", user: ");
        return result;
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The user to follow (screen name, e.g., '@TheAdamsFlow').";
    }

    @Override
    public void startExecution() {
        try {
            String name = this.m_User;
            if (name.startsWith("@")) {
                name = name.substring(1);
            }
            if (name.isEmpty()) {
                throw new IllegalStateException("No screen name provided!");
            }
            User user = TwitterHelper.getTwitterConnection(this.getFlowContext()).users().showUser(name);
            if (user == null) {
                throw new IllegalStateException("Failed to retrieve user data for name: " + name);
            }
            this.getLogger().info("Following tweets from user: " + name + "/" + user.getId());
            this.m_Twitter.addListener((StreamListener)this);
            FilterQuery filter = new FilterQuery();
            filter.follow(new long[]{user.getId()});
            this.m_Twitter.filter(filter);
            this.m_Listening = true;
        }
        catch (Exception e) {
            this.m_Twitter.removeListener((StreamListener)this);
            this.getLogger().log(Level.SEVERE, "Failed to start listener!", (Throwable)e);
        }
    }

    @Override
    protected void removeListener() {
        this.m_Twitter.removeListener((StreamListener)this);
    }

    public void onDeletionNotice(long directMessageId, long userId) {
    }

    public void onFriendList(long[] friendIds) {
    }

    public void onFavorite(User source, User target, Status favoritedStatus) {
    }

    public void onUnfavorite(User source, User target, Status unfavoritedStatus) {
    }

    public void onFollow(User source, User followedUser) {
    }

    public void onUnfollow(User source, User unfollowedUser) {
    }

    public void onDirectMessage(DirectMessage directMessage) {
    }

    public void onUserListMemberAddition(User addedMember, User listOwner, UserList list) {
    }

    public void onUserListMemberDeletion(User deletedMember, User listOwner, UserList list) {
    }

    public void onUserListSubscription(User subscriber, User listOwner, UserList list) {
    }

    public void onUserListUnsubscription(User subscriber, User listOwner, UserList list) {
    }

    public void onUserListCreation(User listOwner, UserList list) {
    }

    public void onUserListUpdate(User listOwner, UserList list) {
    }

    public void onUserListDeletion(User listOwner, UserList list) {
    }

    public void onUserProfileUpdate(User updatedUser) {
    }

    public void onUserSuspension(long suspendedUser) {
    }

    public void onUserDeletion(long deletedUser) {
    }

    public void onBlock(User source, User blockedUser) {
    }

    public void onUnblock(User source, User unblockedUser) {
    }

    public void onRetweetedRetweet(User source, User target, Status retweetedStatus) {
    }

    public void onFavoritedRetweet(User source, User target, Status favoritedRetweeet) {
    }

    public void onQuotedTweet(User source, User target, Status quotingTweet) {
    }

    public void onStatus(Status status) {
        if (this.m_Listening && !this.m_Paused) {
            if (this.getMaxStatusUpdates() > 0 && this.m_Count >= this.getMaxStatusUpdates()) {
                this.stopExecution();
            } else {
                this.m_Next = status;
            }
        }
    }

    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
    }

    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
    }

    public void onScrubGeo(long userId, long upToStatusId) {
    }

    public void onStallWarning(StallWarning warning) {
    }

    public void onException(Exception ex) {
    }
}

