/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.net.TwitterHelper;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.HashMap;
import java.util.Map;
import twitter4j.Twitter;
import twitter4j.User;

public class TwitterUser
extends AbstractTransformer {
    private static final long serialVersionUID = 5809210150081226732L;
    protected Twitter m_Twitter;

    public String globalInfo() {
        return "Outputs the user information for the user (screen name or ID).";
    }

    public Class[] accepts() {
        return new Class[]{String.class, Long.class, Integer.class};
    }

    public Class[] generates() {
        return new Class[]{Map.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Twitter = TwitterHelper.getTwitterConnection((Actor)this);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Long id = null;
        String name = null;
        User user = null;
        if (this.m_InputToken.getPayload() instanceof Long) {
            id = (Long)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof Integer) {
            id = ((Integer)this.m_InputToken.getPayload()).longValue();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            name = (String)this.m_InputToken.getPayload();
        }
        try {
            if (name != null) {
                user = this.m_Twitter.users().showUser(name);
            } else if (id != null) {
                user = this.m_Twitter.users().showUser(id.longValue());
            } else {
                result = "Neither name nor ID provided!";
            }
            if (user != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", "" + user.getId());
                map.put("name", user.getName());
                map.put("screenname", user.getScreenName());
                map.put("lang", user.getLang());
                map.put("description", user.getDescription());
                map.put("location", user.getLocation());
                map.put("timezone", user.getTimeZone());
                map.put("url", user.getURL());
                map.put("favoritescount", "" + user.getFavouritesCount());
                map.put("followerscount", "" + user.getFollowersCount());
                map.put("friendscount", "" + user.getFriendsCount());
                map.put("statusescount", "" + user.getStatusesCount());
                map.put("listedcount", "" + user.getListedCount());
                map.put("status", user.getStatus().getText());
                this.m_OutputToken = new Token(map);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to determine ID for user: " + name, e);
        }
        return result;
    }
}

