/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.parser.AbstractSymbolEvaluator;
import adams.parser.twitterfilter.Parser;
import adams.parser.twitterfilter.Scanner;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class TwitterFilter
extends AbstractSymbolEvaluator<Boolean> {
    private static final long serialVersionUID = -1217454324054448107L;

    public String globalInfo() {
        return "Evaluates Twitter filter expressions.\n\nThe expressions use the following grammar:\n\n" + this.getGrammar();
    }

    public String getGrammar() {
        return "expr_list ::= expr_list expr | expr;\nexpr      ::=   ( expr )\n              | boolexpr\n              ;\n\nboolexpr ::=    BOOLEAN\n              | ( boolexpr )\n              | not boolexpr\n              | boolexpr and boolexpr\n              | boolexpr or boolexpr\n              | boolexpr xor boolexpr\n              | numexpr < numexpr\n              | numexpr <= numexpr\n              | numexpr = numexpr\n              | numexpr > numexpr\n              | numexpr >= numexpr\n              | numexpr <> numexpr\n\n              | retweet\n              | isretweeted\n\n              | langcode <match> pattern\n              | country <match> pattern\n              | countrycode <match> pattern\n              | place <match> pattern\n              | source <match> pattern\n              | text <match> pattern\n              | user <match> pattern\n              | screenname <match> pattern\n              | hashtag <match> pattern\n              | usermention <match> pattern\n              | statuslang <match> pattern\n\n              | if[else] ( boolexpr:test , boolexpr:test_true , boolexpr:test_false )\n              | has ( parameter )\n              ;\n\nnumexpr  ::=    num\n              | longitude\n              | latitude\n              | favcount\n              ;\n\nparameter ::=   langcode\n              | country\n              | countrycode\n              | place\n              | source\n              | text\n              | user\n              | longitude\n              | latitude\n              ;\n\nThe '<match>' operator can be one of the following:\n1. '=' - exact match (the twitter field must be the exact 'pattern' string)\n2. ':' - substring match (the 'pattern' can occur anywhere in the twitter field)\n3. '~' - regular expression match (the 'pattern' is a regular expression that the twitter field must match)\n\nPlease note, all strings are converted to lower case before the filter is applied.";
    }

    protected String getDefaultExpression() {
        return "text~\".*\"";
    }

    public String expressionTipText() {
        return "The filter expression to evaluate.";
    }

    protected Object initializeSymbol(String name, String value) {
        return value;
    }

    protected Boolean doEvaluate(HashMap symbols) throws Exception {
        return TwitterFilter.evaluate(this.m_Expression, symbols);
    }

    public static boolean evaluate(String expr, HashMap symbols) throws Exception {
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        TwitterFilter.runEvaluator(TwitterFilter.class, (String[])args);
    }
}

