/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.data.twitter.SimulatedHashtagEntity;
import adams.data.twitter.SimulatedUserMentionEntity;
import adams.data.twitter.TwitterField;
import adams.env.Environment;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.TwitterConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import twitter4j.HashtagEntity;
import twitter4j.Status;
import twitter4j.SymbolEntity;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.URLEntity;
import twitter4j.UserMentionEntity;

public class TwitterHelper {
    public static final String FILENAME = "Twitter.props";
    public static final String CONSUMER_KEY = "ConsumerKey";
    public static final String CONSUMER_SECRET = "ConsumerSecret";
    public static final String ACCESS_TOKEN = "AccessToken";
    public static final String ACCESS_TOKEN_SECRET = "AccessTokenSecret";
    public static final String SYMBOL_HASHTAGS = "hashtags";
    public static final String SYMBOL_USERMENTIONS = "usermentions";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("twitter");
                System.setProperty("twitter4j.debug", "" + m_Properties.getBoolean("Debug", Boolean.valueOf(false)));
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return TwitterHelper.writeProperties(TwitterHelper.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        boolean result = Environment.getInstance().write("twitter", props);
        m_Properties = null;
        return result;
    }

    public static String getConsumerKey() {
        return TwitterHelper.getProperties().getPath(CONSUMER_KEY, "");
    }

    public static BasePassword getConsumerSecret() {
        return new BasePassword(TwitterHelper.getProperties().getPath(CONSUMER_SECRET, ""));
    }

    public static String getAccessToken() {
        return TwitterHelper.getProperties().getPath(ACCESS_TOKEN, "");
    }

    public static BasePassword getAccessTokenSecret() {
        return new BasePassword(TwitterHelper.getProperties().getPath(ACCESS_TOKEN_SECRET, ""));
    }

    protected static TwitterConnection getTwitterConnectionActor(Actor actor) {
        return (TwitterConnection)ActorUtils.findClosestType((Actor)actor, TwitterConnection.class, (boolean)true);
    }

    public static Twitter getTwitterConnection(Actor actor) {
        TwitterConnection conn = TwitterHelper.getTwitterConnectionActor(actor);
        Twitter result = conn == null ? new TwitterFactory().getInstance() : conn.getTwitterConnection();
        return result;
    }

    public static TwitterStream getTwitterStreamConnection(Actor actor) {
        TwitterStream result = null;
        TwitterConnection conn = TwitterHelper.getTwitterConnectionActor(actor);
        if (conn != null) {
            result = conn.getTwitterStreamConnection();
        }
        return result;
    }

    public static Hashtable<TwitterField, Object> statusToHashtable(Status status) {
        ArrayList<String> list;
        Hashtable<TwitterField, Object> result = new Hashtable<TwitterField, Object>();
        result.put(TwitterField.ID, status.getId());
        if (status.getUser() != null) {
            result.put(TwitterField.USER_ID, status.getUser().getId());
            if (status.getUser().getName() != null) {
                result.put(TwitterField.USER_NAME, status.getUser().getName());
            }
            if (status.getUser().getScreenName() != null) {
                result.put(TwitterField.USER_SCREENNAME, status.getUser().getScreenName());
            }
        }
        result.put(TwitterField.SOURCE, status.getSource());
        result.put(TwitterField.TEXT, status.getText());
        if (status.getCreatedAt() != null) {
            result.put(TwitterField.CREATED, status.getCreatedAt());
        }
        result.put(TwitterField.FAVORITED, status.isFavorited());
        result.put(TwitterField.RETWEET, status.isRetweet());
        result.put(TwitterField.IN_REPLY_TO_STATUS_ID, status.getInReplyToStatusId());
        result.put(TwitterField.IN_REPLY_TO_USER_ID, status.getInReplyToUserId());
        if (status.getRetweetedStatus() != null) {
            result.put(TwitterField.RETWEETED_STATUS_ID, status.getRetweetedStatus().getId());
            if (status.getRetweetedStatus().getUser() != null) {
                result.put(TwitterField.RETWEETED_STATUS_USER_ID, status.getRetweetedStatus().getUser().getId());
            }
            if (status.getRetweetedStatus().getCreatedAt() != null) {
                result.put(TwitterField.RETWEETED_STATUS_CREATED, status.getRetweetedStatus().getCreatedAt());
            }
        }
        result.put(TwitterField.RETWEET_BY_ME, status.isRetweetedByMe());
        result.put(TwitterField.RETWEET_COUNT, status.getRetweetCount());
        result.put(TwitterField.POSSIBLY_SENSITIVE, status.isPossiblySensitive());
        if (status.getGeoLocation() != null) {
            result.put(TwitterField.GEO_LATITUDE, status.getGeoLocation().getLatitude());
            result.put(TwitterField.GEO_LONGITUDE, status.getGeoLocation().getLongitude());
        }
        if (status.getPlace() != null) {
            if (status.getPlace().getPlaceType() != null) {
                result.put(TwitterField.PLACE_TYPE, status.getPlace().getPlaceType());
            }
            if (status.getPlace().getURL() != null) {
                result.put(TwitterField.PLACE_URL, status.getPlace().getURL());
            }
            if (status.getPlace().getStreetAddress() != null) {
                result.put(TwitterField.STREET_ADDRESS, status.getPlace().getStreetAddress());
            }
            if (status.getPlace().getCountryCode() != null) {
                result.put(TwitterField.COUNTRY_CODE, status.getPlace().getCountryCode());
            }
            if (status.getPlace().getCountry() != null) {
                result.put(TwitterField.COUNTRY, status.getPlace().getCountry());
            }
            if (status.getPlace().getName() != null) {
                result.put(TwitterField.PLACE, status.getPlace().getName());
            }
        }
        if (status.getURLEntities() != null) {
            list = new ArrayList<String>();
            for (URLEntity uRLEntity : status.getURLEntities()) {
                list.add(uRLEntity.getExpandedURL());
            }
            if (list.size() > 0) {
                result.put(TwitterField.EXPANDED_URLS, Utils.flatten(list, (String)","));
            }
        }
        if (status.getSymbolEntities() != null) {
            list = new ArrayList();
            for (SymbolEntity symbolEntity : status.getSymbolEntities()) {
                list.add(symbolEntity.getText());
            }
            if (list.size() > 0) {
                result.put(TwitterField.SYMBOL_ENTITIES, Utils.flatten(list, (String)","));
            }
        }
        result.put(TwitterField.IS_RETWEETED, status.isRetweeted());
        result.put(TwitterField.FAVORITE_COUNT, status.getFavoriteCount());
        if (status.getLang() != null) {
            result.put(TwitterField.STATUS_LANG, status.getLang());
        }
        if (status.getScopes() != null) {
            list = new ArrayList();
            for (String string : status.getScopes().getPlaceIds()) {
                list.add(string);
            }
            if (list.size() > 0) {
                result.put(TwitterField.SCOPES, Utils.flatten(list, (String)","));
            }
        }
        if (status.getWithheldInCountries() != null && status.getWithheldInCountries().length > 0) {
            result.put(TwitterField.WITHHELD_IN_COUNTRIES, Utils.flatten((Object[])status.getWithheldInCountries(), (String)","));
        }
        result.put(TwitterField.QUOTED_STATUS_ID, status.getQuotedStatusId());
        if (status.getQuotedStatus() != null) {
            result.put(TwitterField.QUOTED_STATUS, status.getQuotedStatus().getText());
        }
        return result;
    }

    public static HashMap statusToSymbols(Status status, boolean lowerCase) {
        int i;
        String[] values;
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Hashtable<TwitterField, Object> table = TwitterHelper.statusToHashtable(status);
        for (TwitterField field : table.keySet()) {
            Object value = table.get((Object)field);
            if (lowerCase && value instanceof String) {
                value = ((String)value).toLowerCase();
            }
            result.put((Object)field, value);
        }
        if (status.getHashtagEntities() != null) {
            values = new String[status.getHashtagEntities().length];
            for (i = 0; i < status.getHashtagEntities().length; ++i) {
                values[i] = status.getHashtagEntities()[i].getText();
            }
        } else {
            values = new String[]{};
        }
        result.put(SYMBOL_HASHTAGS, values);
        if (status.getUserMentionEntities() != null) {
            values = new String[status.getUserMentionEntities().length];
            for (i = 0; i < status.getUserMentionEntities().length; ++i) {
                values[i] = status.getUserMentionEntities()[i].getScreenName();
            }
        } else {
            values = new String[]{};
        }
        result.put(SYMBOL_USERMENTIONS, values);
        return result;
    }

    public static HashtagEntity[] extractHashtags(String text) {
        int pos;
        ArrayList<SimulatedHashtagEntity> result = new ArrayList<SimulatedHashtagEntity>();
        String current = "";
        int offset = 0;
        block0: while ((pos = text.indexOf("#")) > -1) {
            offset += pos + 1;
            text = text.substring(pos + 1, text.length());
            for (int i = 0; i < text.length(); ++i) {
                char chr = text.charAt(i);
                if (Character.isLetterOrDigit(chr)) {
                    current = current + chr;
                }
                if (Character.isLetterOrDigit(chr) && i != text.length() - 1) continue;
                if (!current.isEmpty()) {
                    SimulatedHashtagEntity entity = new SimulatedHashtagEntity();
                    entity.setText(current);
                    entity.setStart(offset);
                    entity.setEnd(offset + i - 1);
                    result.add(entity);
                }
                offset += i + 1;
                text = text.substring(i + 1, text.length());
                current = "";
                continue block0;
            }
        }
        return result.toArray(new SimulatedHashtagEntity[result.size()]);
    }

    public static UserMentionEntity[] extractUserMentions(String text) {
        int pos;
        ArrayList<SimulatedUserMentionEntity> result = new ArrayList<SimulatedUserMentionEntity>();
        String current = "";
        int offset = 0;
        block0: while ((pos = text.indexOf("@")) > -1) {
            offset += pos + 1;
            text = text.substring(pos + 1, text.length());
            for (int i = 0; i < text.length(); ++i) {
                char chr = text.charAt(i);
                if (!Character.isLetterOrDigit(chr) || i == text.length() - 1) {
                    if (!current.isEmpty()) {
                        SimulatedUserMentionEntity entity = new SimulatedUserMentionEntity();
                        entity.setName(current);
                        entity.setScreenName(current);
                        entity.setId(-1L);
                        entity.setStart(offset + pos + 1);
                        entity.setEnd(offset + i - 1);
                        result.add(entity);
                    }
                    offset += i + 1;
                    text = text.substring(i + 1, text.length());
                    current = "";
                    continue block0;
                }
                current = current + chr;
            }
        }
        return result.toArray(new SimulatedUserMentionEntity[result.size()]);
    }
}

