/*
 * Decompiled with CFR 0.152.
 */
package adams.data.twitter;

import adams.core.DateTime;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetTypeHandler;
import adams.data.twitter.AbstractTwitterStatusConverter;
import adams.data.twitter.TwitterField;
import java.util.Date;
import java.util.Hashtable;

public class SpreadSheetConverter
extends AbstractTwitterStatusConverter<SpreadSheet>
implements SpreadSheetTypeHandler {
    private static final long serialVersionUID = -4932470309464987225L;
    protected DataRow m_DataRowType;
    protected SpreadSheet m_SpreadSheetType;
    protected SpreadSheet m_Header;

    public String globalInfo() {
        return "Turns a status update into a spreadsheet object containing a single row.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)new DenseDataRow());
        this.m_OptionManager.add("spreadsheet-type", "spreadSheetType", (Object)new DefaultSpreadSheet());
    }

    protected void reset() {
        super.reset();
        this.m_Header = null;
    }

    public void setDataRowType(DataRow value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRow getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setSpreadSheetType(SpreadSheet value) {
        this.m_SpreadSheetType = value;
        this.reset();
    }

    public SpreadSheet getSpreadSheetType() {
        return this.m_SpreadSheetType;
    }

    public String spreadSheetTypeTipText() {
        return "The type of spreadsheet to use for the data.";
    }

    @Override
    public Class generates() {
        if (this.m_SpreadSheetType != null) {
            return this.m_SpreadSheetType.getClass();
        }
        return SpreadSheet.class;
    }

    protected void generateHeader() {
        SpreadSheet sheet = this.m_SpreadSheetType.newInstance();
        sheet.setDataRowClass(this.m_DataRowType.getClass());
        HeaderRow row = sheet.getHeaderRow();
        for (TwitterField field : this.m_Fields) {
            row.addCell("" + row.getCellCount()).setContent(field.toString());
        }
        this.m_Header = sheet;
    }

    @Override
    protected SpreadSheet doConvert(Hashtable fields) {
        if (this.m_Header == null) {
            this.generateHeader();
        }
        SpreadSheet result = this.m_Header.getClone();
        DataRow row = result.addRow();
        for (int i = 0; i < this.m_Fields.length; ++i) {
            Object obj = fields.get((Object)this.m_Fields[i]);
            if (obj == null) continue;
            if (obj instanceof Long) {
                row.addCell(i).setContent((Long)obj);
                continue;
            }
            if (obj instanceof Integer) {
                row.addCell(i).setContent(Long.valueOf(((Integer)obj).longValue()));
                continue;
            }
            if (obj instanceof String) {
                row.addCell(i).setContentAsString((String)obj);
                continue;
            }
            if (obj instanceof Date) {
                row.addCell(i).setContent(new DateTime((Date)obj));
                continue;
            }
            if (obj instanceof Double) {
                row.addCell(i).setContent((Double)obj);
                continue;
            }
            if (obj instanceof Boolean) {
                row.addCell(i).setContent((Boolean)obj);
                continue;
            }
            throw new IllegalStateException("Unhandled tweet field/class: " + (Object)((Object)this.m_Fields[i]) + "/" + obj.getClass().getName());
        }
        return result;
    }
}

