/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.twitterlistener;

import adams.core.Pausable;
import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.Stoppable;
import adams.core.logging.Logger;
import adams.core.net.TwitterHelper;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import twitter4j.Status;
import twitter4j.TwitterStream;

public abstract class AbstractListener
extends AbstractOptionHandler
implements Pausable,
Stoppable,
QuickInfoSupporter,
FlowContextHandler {
    private static final long serialVersionUID = 5406360301457780558L;
    protected int m_MaxStatusUpdates;
    protected Actor m_FlowContext;
    protected transient TwitterStream m_Twitter;
    protected int m_Count;
    protected Status m_Next;
    protected boolean m_Paused;
    protected boolean m_Listening;

    protected void initialize() {
        super.initialize();
        this.m_FlowContext = null;
        this.m_Count = 0;
        this.m_Twitter = null;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-updates", "maxStatusUpdates", (Object)100, (Number)-1, null);
    }

    public void setMaxStatusUpdates(int value) {
        this.m_MaxStatusUpdates = value;
        this.reset();
    }

    public int getMaxStatusUpdates() {
        return this.m_MaxStatusUpdates;
    }

    public String maxStatusUpdatesTipText() {
        return "The maximum number of status updates to output; use <=0 for unlimited.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"maxStatusUpdates", (Object)((this.m_MaxStatusUpdates <= 0 ? "unlimited " : "" + this.m_MaxStatusUpdates) + " status updates"));
    }

    public synchronized Logger getLogger() {
        if (this.m_FlowContext != null) {
            return this.m_FlowContext.getLogger();
        }
        return super.getLogger();
    }

    public void setFlowContext(Actor value) {
        if (value == null) {
            throw new IllegalArgumentException("Flow context cannot be null!");
        }
        this.m_FlowContext = value;
        this.m_Count = 0;
        this.m_Twitter = TwitterHelper.getTwitterStreamConnection(this.getFlowContext());
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    public abstract void startExecution();

    public boolean isListening() {
        return this.m_Listening;
    }

    public void pauseExecution() {
        if (this.m_Listening) {
            this.m_Paused = true;
        }
    }

    public boolean isPaused() {
        return this.m_Paused;
    }

    public void resumeExecution() {
        this.m_Paused = false;
    }

    protected abstract void removeListener();

    public void stopExecution() {
        this.m_Listening = false;
        this.m_Paused = false;
        this.removeListener();
        try {
            this.m_Twitter.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Twitter.cleanUp();
    }

    public boolean hasNext() {
        return this.m_Listening || this.m_Next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status next() {
        Status result = null;
        int count = 0;
        while (result == null) {
            result = this.m_Next;
            ++count;
            if (result == null) {
                if (!this.m_Listening) break;
                try {
                    AbstractListener abstractListener = this;
                    synchronized (abstractListener) {
                        ((Object)((Object)this)).wait(50L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (count != 100) continue;
        }
        if (result != null) {
            ++this.m_Count;
            if (this.getFlowContext().isLoggingEnabled() && this.m_Count % 100 == 0) {
                this.getLogger().info("status updates: " + this.m_Count);
            }
        }
        this.m_Next = null;
        return result;
    }
}

